/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests.trim;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CtfTmfExperimentTrimmingTest {
    private static final String TRACE_TYPE = "org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace";
    private static final String PROJECT_NAME = "Test";
    private static final int NUM_TRACES = 4;
    @Rule
    public TestRule globalTimeout = new Timeout(6L, TimeUnit.MINUTES);
    private static SWTWorkbenchBot fBot;
    private TmfTimeRange fRequestedTraceCutRange;
    private ITmfTrace fOriginalExperiment;
    private ITmfTrace fNewExperiment;

    @BeforeClass
    public static void beforeClass() throws IOException {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 50000L;
        File parentDir = FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.TRACE_EXPERIMENT.getTraceURL()));
        File[] traceFiles = parentDir.listFiles();
        CtfTmfTrace traceValidator = new CtfTmfTrace();
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.createProject((String)PROJECT_NAME);
        int openedTraces = 0;
        File[] fileArray = traceFiles;
        int n = traceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File traceFile = fileArray[n2];
            String absolutePath = traceFile.getAbsolutePath();
            if (traceValidator.validate(null, absolutePath).isOK()) {
                SWTBotUtils.openTrace((String)PROJECT_NAME, (String)absolutePath, (String)TRACE_TYPE);
                fBot.closeAllEditors();
                if (++openedTraces >= 4) break;
            }
            ++n2;
        }
        traceValidator.dispose();
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @Before
    public void setup() {
        WaitUtils.waitForJobs();
        SWTBotTreeItem tracesFolder = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)PROJECT_NAME);
        tracesFolder.contextMenu().menu(new String[]{"Open As Experiment...", "Generic Experiment"}).click();
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)"Experiment");
        SWTBotTreeItem project = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)PROJECT_NAME);
        SWTBotTreeItem experimentItem = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, (SWTBotTreeItem)project, (String[])new String[]{"Experiments", "Experiment"});
        experimentItem.select();
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        ITmfTrace trace = traceManager.getActiveTrace();
        Assert.assertTrue((String)String.valueOf(trace), (boolean)(trace instanceof TmfExperiment));
        TmfExperiment experiment = (TmfExperiment)trace;
        Assert.assertNotNull((Object)experiment);
        ITmfProjectModelElement elem = TmfProjectRegistry.findElement((IResource)experiment.getResource(), (boolean)true);
        Assert.assertTrue((boolean)(elem instanceof TmfExperimentElement));
        this.fOriginalExperiment = experiment;
        TmfTimeRange traceCutRange = CtfTmfExperimentTrimmingTest.getTraceCutRange((ITmfTrace)experiment);
        Assert.assertNotNull((Object)traceCutRange);
        this.fRequestedTraceCutRange = traceCutRange;
        ITmfTimestamp requestedTraceCutEnd = traceCutRange.getEndTime();
        ITmfTimestamp requestedTraceCutStart = traceCutRange.getStartTime();
        Assert.assertTrue((boolean)experiment.getTimeRange().contains(traceCutRange));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)this, requestedTraceCutStart, requestedTraceCutEnd, (ITmfTrace)experiment));
        experimentItem.contextMenu("Export Time Selection as New Trace...").click();
        SWTBotShell shell = fBot.shell("Export trace section to...").activate();
        SWTBot dialogBot = shell.bot();
        Assert.assertEquals((Object)"Experiment", (Object)dialogBot.text().getText());
        dialogBot.text().setText("Experiment-trimmed");
        dialogBot.button("OK").click();
        SWTBotEditor newExperiment = fBot.editorByTitle("Experiment-trimmed");
        newExperiment.setFocus();
        this.fNewExperiment = traceManager.getActiveTrace();
        Assert.assertNotNull((String)"No active trace", (Object)this.fNewExperiment);
        Assert.assertEquals((String)"Incorrect active trace", (Object)"Experiment-trimmed", (Object)this.fNewExperiment.getName());
        WaitUtils.waitForJobs();
    }

    private static TmfTimeRange getTraceCutRange(ITmfTrace trace) {
        long start = trace.readStart().toNanos();
        long end = trace.readEnd().toNanos();
        long duration = end - start;
        return new TmfTimeRange(TmfTimestamp.fromNanos((long)(duration / 4L + start)), TmfTimestamp.fromNanos((long)(duration / 2L + start)));
    }

    @Test
    public void testTrimEvents() {
        ITmfTrace initialTrace = this.fOriginalExperiment;
        ITmfTrace trimmedTrace = this.fNewExperiment;
        Assert.assertNotNull((Object)initialTrace);
        Assert.assertNotNull((Object)trimmedTrace);
        ITmfContext trimmedContext = trimmedTrace.seekEvent(0L);
        ITmfEvent trimmedEvent = trimmedTrace.getNext(trimmedContext);
        Assert.assertNotNull((Object)trimmedEvent);
        long newTraceStartTime = trimmedTrace.readStart().toNanos();
        long newTraceEndTime = trimmedTrace.readEnd().toNanos();
        Assert.assertTrue((String)("Trimmed trace start time " + newTraceStartTime + " is earlier than the requested " + this.fRequestedTraceCutRange.getStartTime()), (newTraceStartTime >= this.fRequestedTraceCutRange.getStartTime().toNanos() ? 1 : 0) != 0);
        Assert.assertTrue((String)("Trimmed trace end time " + newTraceEndTime + " is later than the requested " + this.fRequestedTraceCutRange.getEndTime()), (newTraceEndTime <= this.fRequestedTraceCutRange.getEndTime().toNanos() ? 1 : 0) != 0);
        TmfTimeRange traceCutRange = this.fRequestedTraceCutRange;
        ITmfTimestamp startTime = traceCutRange.getStartTime();
        ITmfContext initialContext = initialTrace.seekEvent(startTime);
        ITmfEvent initialEvent = initialTrace.getNext(initialContext);
        int count = 0;
        while (traceCutRange.contains(initialEvent.getTimestamp())) {
            Assert.assertNotNull((String)("Expected event not present in trimmed trace: " + initialEvent + " at rank:" + count), (Object)trimmedEvent);
            Assert.assertEquals((String)("Timestamp mismatch at rank:" + count), (Object)initialEvent.getTimestamp(), (Object)trimmedEvent.getTimestamp());
            initialEvent = initialTrace.getNext(initialContext);
            trimmedEvent = trimmedTrace.getNext(trimmedContext);
            ++count;
        }
        Assert.assertTrue((String)"Trimmed trace is too small", ((long)count <= trimmedTrace.getNbEvents() ? 1 : 0) != 0);
    }
}

