/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpressionCu;

public class FilterSimpleExpression
implements Predicate<Multimap<String, Object>> {
    private final String fField;
    private final BiPredicate<Object, Object> fOperator;
    private final @Nullable String fOriginalValue;
    private final @Nullable Object fValue;

    public FilterSimpleExpression(String field, FilterSimpleExpressionCu.ConditionOperator operator, @Nullable String value) {
        this.fField = field;
        this.fOperator = operator;
        this.fOriginalValue = value;
        this.fValue = FilterSimpleExpressionCu.ConditionOperator.prepareValue(operator, value);
    }

    @Override
    public boolean test(Multimap<String, Object> data) {
        Object value = this.fValue;
        return Iterables.any((Iterable)data.entries(), entry -> !(!this.fField.equals("*") && !Objects.requireNonNull((String)entry.getKey()).equals(this.fField) && !Objects.requireNonNull((String)entry.getKey()).equals("> " + this.fField) || value != null && !this.fOperator.test(entry.getValue(), value)));
    }

    public String toString() {
        return String.valueOf(this.fField) + this.fOperator + this.fOriginalValue;
    }
}

