/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editorsupport.win32;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editorsupport.win32.OleMessages;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class OleEditor
extends EditorPart {
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta mainDelta = event.getDelta();
            if (mainDelta == null) {
                return;
            }
            IResourceDelta affectedElement = mainDelta.findMember(OleEditor.this.resource.getFullPath());
            if (affectedElement != null) {
                this.processDelta(affectedElement);
            }
        }

        private boolean processDelta(IResourceDelta delta) {
            Runnable changeRunnable = null;
            switch (delta.getKind()) {
                case 2: {
                    changeRunnable = (0x2000 & delta.getFlags()) != 0 ? () -> {
                        IPath path = delta.getMovedToPath();
                        IFile newFile = delta.getResource().getWorkspace().getRoot().getFile(path);
                        if (newFile != null) {
                            OleEditor.this.sourceChanged(newFile);
                        }
                    } : () -> {
                        OleEditor.this.sourceDeleted = true;
                        OleEditor.this.getSite().getPage().closeEditor((IEditorPart)OleEditor.this, true);
                    };
                }
            }
            if (changeRunnable != null) {
                OleEditor.this.update(changeRunnable);
            }
            return true;
        }
    };
    private OleFrame clientFrame;
    private OleClientSite clientSite;
    private File source;
    private IFile resource;
    private Image oleTitleImage;
    boolean sourceDeleted = false;
    boolean sourceChanged = false;
    private static final String RENAME_ERROR_TITLE = OleMessages.getString("OleEditor.errorSaving");
    private static final String OLE_EXCEPTION_TITLE = OleMessages.getString("OleEditor.oleExceptionTitle");
    private static final String OLE_EXCEPTION_MESSAGE = OleMessages.getString("OleEditor.oleExceptionMessage");
    private static final String OLE_CREATE_EXCEPTION_MESSAGE = OleMessages.getString("OleEditor.oleCreationExceptionMessage");
    private static final String OLE_CREATE_EXCEPTION_REASON = OleMessages.getString("OleEditor.oleCreationExceptionReason");
    private static final String SAVE_ERROR_TITLE = OleMessages.getString("OleEditor.savingTitle");
    private static final String SAVE_ERROR_MESSAGE = OleMessages.getString("OleEditor.savingMessage");
    private boolean isDirty = false;

    public void createPartControl(Composite parent) {
        this.clientFrame = new OleFrame(parent, 4096);
        this.clientFrame.setBackground(JFaceColors.getBannerBackground((Display)this.clientFrame.getDisplay()));
        this.initializeWorkbenchMenus();
        this.createClientSite();
        this.updateDirtyFlag();
        this.oleActivate();
    }

    private void createClientSite() {
        if (this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        try {
            this.clientSite = new OleClientSite((Composite)this.clientFrame, 0, this.source);
        }
        catch (SWTException exception) {
            Status errorStatus = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 4, OLE_CREATE_EXCEPTION_REASON, (Throwable)exception);
            ErrorDialog.openError(null, (String)OLE_EXCEPTION_TITLE, (String)OLE_CREATE_EXCEPTION_MESSAGE, (IStatus)errorStatus);
            return;
        }
        this.clientSite.setBackground(JFaceColors.getBannerBackground((Display)this.clientFrame.getDisplay()));
    }

    private void displayErrorDialog(String title, String message) {
        Shell parent = null;
        if (this.getClientSite() != null) {
            parent = this.getClientSite().getShell();
        }
        MessageDialog.openError((Shell)parent, (String)title, (String)message);
    }

    public void dispose() {
        if (this.resource != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resource = null;
        }
        if (this.oleTitleImage != null) {
            this.oleTitleImage.dispose();
            this.oleTitleImage = null;
        }
    }

    public void doPrint() {
        if (this.clientSite == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.clientSite.getDisplay(), () -> {
            int n = this.clientSite.exec(6, 1, null, null);
        });
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.clientSite == null) {
            return;
        }
        BusyIndicator.showWhile((Display)this.clientSite.getDisplay(), () -> {
            int result;
            if (!this.sourceChanged && ((result = this.clientSite.queryStatus(3)) & 2) != 0) {
                result = this.clientSite.exec(3, 1, null, null);
                if (result == 0) {
                    try {
                        this.resource.refreshLocal(0, monitor);
                    }
                    catch (CoreException coreException) {}
                    return;
                }
                this.displayErrorDialog(OLE_EXCEPTION_TITLE, String.valueOf(OLE_EXCEPTION_MESSAGE) + String.valueOf(result));
                return;
            }
            if (this.saveFile(this.source)) {
                try {
                    if (this.resource != null) {
                        this.resource.refreshLocal(0, monitor);
                    }
                }
                catch (CoreException coreException) {}
            } else {
                this.displayErrorDialog(SAVE_ERROR_TITLE, String.valueOf(SAVE_ERROR_MESSAGE) + this.source.getName());
            }
        });
    }

    public void doSaveAs() {
        if (this.clientSite == null) {
            return;
        }
        WorkspaceModifyOperation op = this.saveNewFileOperation();
        Shell shell = this.clientSite.getShell();
        try {
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationException) {
            MessageDialog.openError((Shell)shell, (String)RENAME_ERROR_TITLE, (String)invocationException.getTargetException().getMessage());
        }
    }

    public OleClientSite getClientSite() {
        return this.clientSite;
    }

    public File getSourceFile() {
        return this.source;
    }

    private void handleWord() {
        Variant pVarResult;
        OleAutomation dispInterface = new OleAutomation(this.clientSite);
        int[] appId = dispInterface.getIDsOfNames(new String[]{"Application"});
        if (appId != null && (pVarResult = dispInterface.getProperty(appId[0])) != null) {
            OleAutomation application = pVarResult.getAutomation();
            int[] dispid = application.getIDsOfNames(new String[]{"DisplayScrollBars"});
            if (dispid != null) {
                Variant rgvarg = new Variant(true);
                application.setProperty(dispid[0], rgvarg);
            }
            application.dispose();
        }
        dispInterface.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.validatePathEditorInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
        ImageDescriptor desc = input.getImageDescriptor();
        if (desc != null) {
            this.oleTitleImage = desc.createImage();
            this.setTitleImage(this.oleTitleImage);
        }
    }

    private boolean validatePathEditorInput(IEditorInput input) throws PartInitException {
        IPathEditorInput pathEditorInput = (IPathEditorInput)Adapters.adapt((Object)input, IPathEditorInput.class);
        if (pathEditorInput == null) {
            throw new PartInitException(OleMessages.format("OleEditor.invalidInput", new Object[]{input}));
        }
        IPath path = pathEditorInput.getPath();
        if (!new File(path.toOSString()).exists()) {
            throw new PartInitException(OleMessages.format("OleEditor.noFileInput", new Object[]{path.toOSString()}));
        }
        return true;
    }

    protected void initializeWorkbenchMenus() {
        if (this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        Shell shell = this.clientFrame.getShell();
        Menu menuBar = shell.getMenuBar();
        if (menuBar == null) {
            menuBar = new Menu((Decorations)shell, 2);
            shell.setMenuBar(menuBar);
        }
        MenuItem[] windowMenu = new MenuItem[1];
        MenuItem[] fileMenu = new MenuItem[1];
        Vector<MenuItem> containerItems = new Vector<MenuItem>();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        int i = 0;
        while (i < menuBar.getItemCount()) {
            MenuItem item = menuBar.getItem(i);
            String id = "";
            if (item.getData() instanceof IMenuManager) {
                id = ((IMenuManager)item.getData()).getId();
            }
            if (id.equals("file")) {
                fileMenu[0] = item;
            } else if (id.equals("window")) {
                windowMenu[0] = item;
            } else if (window.isApplicationMenu(id)) {
                containerItems.addElement(item);
            }
            ++i;
        }
        Object[] containerMenu = new MenuItem[containerItems.size()];
        containerItems.copyInto(containerMenu);
        this.clientFrame.setFileMenus(fileMenu);
        this.clientFrame.setContainerMenus((MenuItem[])containerMenu);
        this.clientFrame.setWindowMenus(windowMenu);
    }

    public boolean isDirty() {
        return this.clientSite != null && this.clientSite.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveNeeded() {
        return this.isDirty();
    }

    private boolean saveFile(File file) {
        File tempFile = new File(String.valueOf(file.getAbsolutePath()) + ".tmp");
        file.renameTo(tempFile);
        boolean saved = false;
        saved = OLE.isOleFile((File)file) || OleEditor.usesStorageFiles(this.clientSite.getProgramID()) ? this.clientSite.save(file, true) : this.clientSite.save(file, false);
        if (saved) {
            tempFile.delete();
            return true;
        }
        tempFile.renameTo(file);
        return false;
    }

    private WorkspaceModifyOperation saveNewFileOperation() {
        return new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                SaveAsDialog dialog = new SaveAsDialog(OleEditor.this.clientFrame.getShell());
                IFile sFile = ResourceUtil.getFile((IEditorInput)OleEditor.this.getEditorInput());
                if (sFile != null) {
                    dialog.setOriginalFile(sFile);
                    dialog.open();
                    IPath newPath = dialog.getResult();
                    if (newPath == null) {
                        return;
                    }
                    if (dialog.getReturnCode() == 0) {
                        String projectName = newPath.segment(0);
                        newPath = newPath.removeFirstSegments(1);
                        IProject project = OleEditor.this.resource.getWorkspace().getRoot().getProject(projectName);
                        newPath = project.getLocation().append(newPath);
                        File newFile = newPath.toFile();
                        if (OleEditor.this.saveFile(newFile)) {
                            IFile newResource = OleEditor.this.resource.getWorkspace().getRoot().getFileForLocation(newPath);
                            if (newResource != null) {
                                OleEditor.this.sourceChanged(newResource);
                                newResource.refreshLocal(0, monitor);
                            }
                        } else {
                            OleEditor.this.displayErrorDialog(SAVE_ERROR_TITLE, String.valueOf(SAVE_ERROR_MESSAGE) + newFile.getName());
                            return;
                        }
                    }
                }
            }
        };
    }

    public void setFocus() {
        if (this.clientSite != null) {
            this.clientSite.setFocus();
        }
    }

    private void oleActivate() {
        if (this.clientSite == null || this.clientFrame == null || this.clientFrame.isDisposed()) {
            return;
        }
        this.clientSite.doVerb(-1);
        String progId = this.clientSite.getProgramID();
        if (progId != null && progId.startsWith("Word.Document")) {
            this.handleWord();
        }
    }

    protected void setInputWithNotify(IEditorInput input) {
        IPathEditorInput pathEditorInput = (IPathEditorInput)Adapters.adapt((Object)input, IPathEditorInput.class);
        if (pathEditorInput != null) {
            this.source = new File(pathEditorInput.getPath().toOSString());
        }
        if (input instanceof IFileEditorInput) {
            if (this.resource == null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
            }
            this.resource = ((IFileEditorInput)input).getFile();
        } else if (this.resource != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resource = null;
        }
        super.setInputWithNotify(input);
    }

    private static boolean usesStorageFiles(String progID) {
        return progID != null && (progID.startsWith("Word.", 0) || progID.startsWith("MSGraph", 0) || progID.startsWith("PowerPoint", 0) || progID.startsWith("Excel", 0));
    }

    private void sourceChanged(IFile newFile) {
        FileEditorInput newInput = new FileEditorInput(newFile);
        this.setInputWithNotify((IEditorInput)newInput);
        this.sourceChanged = true;
        this.setPartName(newInput.getName());
    }

    public boolean isSaveOnCloseNeeded() {
        return !this.sourceDeleted && super.isSaveOnCloseNeeded();
    }

    private void update(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    private void updateDirtyFlag() {
        Runnable dirtyFlagUpdater = new Runnable(){

            @Override
            public void run() {
                if (OleEditor.this.clientSite == null || OleEditor.this.resource == null) {
                    return;
                }
                boolean dirty = OleEditor.this.isDirty();
                if (OleEditor.this.isDirty != dirty) {
                    OleEditor.this.isDirty = dirty;
                    OleEditor.this.firePropertyChange(257);
                }
                OleEditor.this.clientSite.getDisplay().timerExec(1000, (Runnable)this);
            }
        };
        dirtyFlagUpdater.run();
    }
}

