/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public class JsonStructureFieldMemberMetadataNode
extends CTFJsonMetadataNode {
    @SerializedName(value="name")
    private final String fName;
    @SerializedName(value="field-class")
    private final JsonElement fFieldClass;

    public JsonStructureFieldMemberMetadataNode(ICTFMetadataNode parent, String type, String value, String name, JsonObject fieldClass) {
        super(parent, type, value);
        this.fName = name;
        this.fFieldClass = fieldClass;
    }

    public String getName() {
        return this.fName;
    }

    public JsonElement getFieldClass() {
        return this.fFieldClass;
    }

    public String getRole() {
        JsonObject obj;
        String role = null;
        if (this.fFieldClass != null && this.fFieldClass.isJsonObject() && (obj = this.fFieldClass.getAsJsonObject()).has("roles")) {
            JsonArray roles = obj.get("roles").getAsJsonArray();
            role = roles.get(0).getAsString();
        }
        return role;
    }

    @Override
    public void initialize() throws CTFException {
        if (this.fFieldClass.isJsonObject() && this.fFieldClass.getAsJsonObject().has("type")) {
            this.setType(this.fFieldClass.getAsJsonObject().get("type").getAsString());
        } else {
            this.setType("alias");
        }
        super.initialize();
    }
}

