/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeBridge;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.internal.AbstractRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.internal.RuntimeManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgedRuntime
extends AbstractRuntime {
    private final String bridgeId;
    private final String nativeRuntimeId;
    private final IRuntimeBridge.IStub stub;
    private Set<IProjectFacetVersion> supported;
    private List<IRuntimeComponent> composition;

    BridgedRuntime(String bridgeId, String nativeRuntimeId, IRuntimeBridge.IStub stub) {
        this.bridgeId = bridgeId;
        this.nativeRuntimeId = nativeRuntimeId;
        this.stub = stub;
    }

    String getBridgeId() {
        return this.bridgeId;
    }

    String getNativeRuntimeId() {
        return this.nativeRuntimeId;
    }

    @Override
    public List<IRuntimeComponent> getRuntimeComponents() {
        List<IRuntimeComponent> components = this.stub.getRuntimeComponents();
        for (IRuntimeComponent rc : components) {
            ((RuntimeComponent)rc).setRuntime(this);
        }
        return Collections.unmodifiableList(components);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.stub.getProperties());
    }

    @Override
    public synchronized boolean supports(IProjectFacetVersion fv) {
        if (fv.getPluginId() == null) {
            return true;
        }
        List<IRuntimeComponent> comp = this.getRuntimeComponents();
        if (this.supported == null || !this.composition.equals(comp)) {
            this.supported = RuntimeManagerImpl.getSupportedFacets(comp);
            this.composition = comp;
        }
        return this.supported.contains(fv);
    }

    @Override
    public IStatus validate(IProgressMonitor monitor) {
        if (this.stub instanceof IRuntimeBridge.Stub) {
            return ((IRuntimeBridge.Stub)this.stub).validate(monitor);
        }
        return super.validate(monitor);
    }
}

