/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.ui.views.flamechart;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackDataProvider;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callstack.provider.CallStackEntryModel;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.views.flamechart.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseDataProviderTimeGraphPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.SymbolProviderConfigDialog;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IEditorPart;

public class FlameChartView
extends BaseDataProviderTimeGraphView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.callstack";
    private static final String[] COLUMN_NAMES = new String[]{Messages.CallStackView_FunctionColumn, Messages.CallStackView_PidTidColumn, Messages.CallStackView_DepthColumn, Messages.CallStackView_EntryTimeColumn, Messages.CallStackView_ExitTimeColumn, Messages.CallStackView_DurationColumn};
    private static final Comparator<ITimeGraphEntry> NAME_COMPARATOR = Comparator.comparing(ITimeGraphEntry::getName);
    private static final Comparator<ITimeGraphEntry> THREAD_ID_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
            TimeGraphEntry t1 = (TimeGraphEntry)o1;
            TimeGraphEntry t2 = (TimeGraphEntry)o2;
            ITmfTreeDataModel model1 = t1.getEntryModel();
            ITmfTreeDataModel model2 = t2.getEntryModel();
            if (model1 instanceof CallStackEntryModel && model2 instanceof CallStackEntryModel) {
                CallStackEntryModel m1 = (CallStackEntryModel)model1;
                CallStackEntryModel m2 = (CallStackEntryModel)model2;
                if (m1.getStackLevel() == 0 && m2.getStackLevel() == 0) {
                    return Long.compare(m1.getPid(), m2.getPid());
                }
            }
        }
        return 0;
    };
    private static final Comparator<ITimeGraphEntry> DEPTH_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
            TimeGraphEntry t1 = (TimeGraphEntry)o1;
            TimeGraphEntry t2 = (TimeGraphEntry)o2;
            ITmfTreeDataModel model1 = t1.getEntryModel();
            ITmfTreeDataModel model2 = t2.getEntryModel();
            if (model1 instanceof CallStackEntryModel && model2 instanceof CallStackEntryModel) {
                return Integer.compare(((CallStackEntryModel)model1).getStackLevel(), ((CallStackEntryModel)model2).getStackLevel());
            }
        }
        return 0;
    };
    private static final Comparator<ITimeGraphEntry>[] COMPARATORS = new Comparator[]{Comparator.comparing(ITimeGraphEntry::getName), THREAD_ID_COMPARATOR, DEPTH_COMPARATOR, Comparator.comparingLong(ITimeGraphEntry::getStartTime), Comparator.comparingLong(ITimeGraphEntry::getEndTime)};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.CallStackView_ThreadColumn};
    private static final Image PROCESS_IMAGE = Objects.requireNonNull(Activator.getDefault()).getImageFromPath("icons/obj16/process_obj.gif");
    private static final Image THREAD_IMAGE = Objects.requireNonNull(Activator.getDefault()).getImageFromPath("icons/obj16/thread_obj.gif");
    private static final Image STACKFRAME_IMAGE = Objects.requireNonNull(Activator.getDefault()).getImageFromPath("icons/obj16/stckframe_obj.gif");
    private static final String IMPORT_BINARY_ICON_PATH = "icons/obj16/binaries_obj.gif";
    private static final Function<@Nullable ITimeGraphEntry, @Nullable String> RESOLVER = entry -> {
        ITmfTreeDataModel model;
        if (entry instanceof TimeGraphEntry && (model = ((TimeGraphEntry)entry).getEntryModel()) instanceof CallStackEntryModel) {
            int type = ((CallStackEntryModel)model).getStackLevel();
            if (type >= 0) {
                return Messages.CallStackPresentationProvider_Thread;
            }
            if (type == -1) {
                return Messages.CallStackPresentationProvider_Process;
            }
        }
        return null;
    };
    private @Nullable Action fNextEventAction;
    private @Nullable Action fPrevEventAction;
    private @Nullable Action fNextItemAction;
    private @Nullable Action fPreviousItemAction;
    private @Nullable Action fConfigureSymbolsAction;
    private boolean fSyncSelection = false;
    private final Map<Long, ITimeGraphState> fFunctions = new HashMap<Long, ITimeGraphState>();

    public FlameChartView() {
        this(ID, (TimeGraphPresentationProvider)new BaseDataProviderTimeGraphPresentationProvider(), "org.eclipse.tracecompass.internal.analysis.profiling.callstack.provider.CallStackDataProvider");
    }

    public FlameChartView(String id, TimeGraphPresentationProvider presentationProvider, String dataProviderID) {
        super(id, presentationProvider, dataProviderID);
        this.setTreeColumns(COLUMN_NAMES, COMPARATORS, 0);
        this.setTreeLabelProvider(new CallStackTreeLabelProvider());
        this.setEntryComparator(new CallStackComparator());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new CallStackTreeLabelProvider());
        this.setStateTypeNameSupplier(RESOLVER);
    }

    public void createPartControl(@Nullable Composite parent) {
        ITmfTrace trace;
        super.createPartControl(parent);
        this.getTimeGraphViewer().addTimeListener(event -> this.synchingToTime(event.getBeginTime()));
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(@Nullable MouseEvent event) {
                ITimeGraphEntry selection = FlameChartView.this.getTimeGraphViewer().getSelection();
                if (!(selection instanceof TimeGraphEntry)) {
                    return;
                }
                ITimeGraphState function = FlameChartView.this.fFunctions.get(((TimeGraphEntry)selection).getEntryModel().getId());
                if (function != null) {
                    long entryTime = function.getStartTime();
                    long exitTime = entryTime + function.getDuration();
                    TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)entryTime), TmfTimestamp.fromNanos((long)exitTime));
                    FlameChartView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)FlameChartView.this, range, FlameChartView.this.getTrace()));
                    FlameChartView.this.getTimeGraphViewer().setStartFinishTime(entryTime, exitTime);
                    FlameChartView.this.startZoomThread(entryTime, exitTime);
                }
            }
        });
        this.getTimeGraphViewer().getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(@Nullable MouseEvent e) {
                TimeGraphControl timeGraphControl = FlameChartView.this.getTimeGraphViewer().getTimeGraphControl();
                ISelection selection = timeGraphControl.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object object : ((IStructuredSelection)selection).toList()) {
                        if (!(object instanceof NamedTimeEvent)) continue;
                        NamedTimeEvent event = (NamedTimeEvent)object;
                        long startTime = event.getTime();
                        long endTime = startTime + event.getDuration();
                        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.fromNanos((long)startTime), TmfTimestamp.fromNanos((long)endTime));
                        FlameChartView.this.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)FlameChartView.this, range, FlameChartView.this.getTrace()));
                        FlameChartView.this.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                        FlameChartView.this.startZoomThread(startTime, endTime);
                        break;
                    }
                }
            }
        });
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(@Nullable TmfSelectionRangeUpdatedSignal signal) {
        this.fSyncSelection = true;
        super.selectionRangeUpdated(signal);
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
        if (signal == null || signal.getSource() == this) {
            return;
        }
        super.windowRangeUpdated(signal);
    }

    protected void rebuild() {
        super.rebuild();
        this.updateConfigureSymbolsAction();
    }

    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        CallStackDataProvider provider = (CallStackDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(trace, this.getProviderId(), CallStackDataProvider.class);
        if (provider == null) {
            this.addUnavailableEntry(trace, parentTrace);
            return;
        }
        provider.resetFunctionNames(monitor);
        super.buildEntryList(trace, parentTrace, monitor);
    }

    private void addUnavailableEntry(ITmfTrace trace, ITmfTrace parentTrace) {
        String name = String.valueOf(Messages.CallStackView_StackInfoNotAvailable) + ' ' + '(' + trace.getName() + ')';
        TimeGraphEntry unavailableEntry = new TimeGraphEntry(name, 0L, 0L){

            public boolean hasTimeEvents() {
                return false;
            }
        };
        this.addToEntryList(parentTrace, Collections.singletonList(unavailableEntry));
        if (parentTrace == this.getTrace()) {
            this.refresh();
        }
    }

    protected TimeEvent createTimeEvent(@Nullable TimeGraphEntry entry, @Nullable ITimeGraphState state) {
        Objects.requireNonNull(state, "state should not be null when creating time event");
        String label = state.getLabel();
        if (state.getValue() == Integer.MIN_VALUE && label == null && state.getStyle() == null) {
            return new NullTimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration());
        }
        if (label != null) {
            return new NamedTimeEvent((ITimeGraphEntry)entry, label, state);
        }
        return new TimeEvent((ITimeGraphEntry)entry, (ITimeElement)state);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void synchingToTime(long time) {
        List traceEntries = this.getEntryList(this.getTrace());
        if (traceEntries != null) {
            for (BaseDataProviderTimeGraphView.TraceEntry traceEntry : Iterables.filter((Iterable)traceEntries, BaseDataProviderTimeGraphView.TraceEntry.class)) {
                Iterable unfiltered = Utils.flatten((TimeGraphEntry)traceEntry);
                ImmutableMap map = Maps.uniqueIndex((Iterable)unfiltered, e -> e.getEntryModel().getId());
                SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(time - 1L, time, 2, map.keySet());
                @NonNull TmfModelResponse response = traceEntry.getProvider().fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter), null);
                TimeGraphModel model = (TimeGraphModel)response.getModel();
                if (model == null) continue;
                for (ITimeGraphRowModel row : model.getRows()) {
                    this.syncToRow(row, time, (Map<Long, TimeGraphEntry>)map);
                }
            }
        }
        this.fSyncSelection = false;
        if (Display.getCurrent() != null) {
            this.getTimeGraphViewer().refresh();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void syncToRow(ITimeGraphRowModel rowModel, long time, Map<Long, TimeGraphEntry> entryMap) {
        long id = rowModel.getEntryID();
        @NonNull List list = rowModel.getStates();
        if (!list.isEmpty()) {
            TimeGraphEntry entry;
            ITimeGraphState event = (ITimeGraphState)list.get(0);
            if (event.getStartTime() + event.getDuration() <= time && list.size() > 1) {
                event = (ITimeGraphState)list.get(1);
            }
            if (event.getLabel() != null) {
                this.fFunctions.put(id, event);
            } else {
                this.fFunctions.remove(id);
            }
            if (this.fSyncSelection && time == event.getStartTime() && (entry = entryMap.get(id)) != null) {
                this.fSyncSelection = false;
                Display.getDefault().asyncExec(() -> {
                    this.getTimeGraphViewer().setSelection((ISelection)entry, true);
                    this.getTimeGraphViewer().getTimeGraphControl().fireSelectionChanged();
                });
            }
        } else {
            this.fFunctions.remove(id);
        }
    }

    private void makeActions() {
        Action nextItemAction;
        Action previousItemAction;
        this.fPreviousItemAction = previousItemAction = this.getTimeGraphViewer().getPreviousItemAction();
        previousItemAction.setText(Messages.FlameChartView_PreviousItemActionNameText);
        previousItemAction.setToolTipText(Messages.FlameChartView_PreviousItemActionToolTipText);
        this.fNextItemAction = nextItemAction = this.getTimeGraphViewer().getNextItemAction();
        nextItemAction.setText(Messages.FlameChartView_NextItemActionNameText);
        nextItemAction.setToolTipText(Messages.FlameChartView_NextItemActionToolTipText);
    }

    protected void fillLocalToolBar(@Nullable IToolBarManager manager) {
        if (manager == null) {
            return;
        }
        this.makeActions();
        manager.appendToGroup("additions", (IAction)this.getConfigureSymbolsAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getShowFilterDialogAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getResetScaleAction());
        manager.appendToGroup("additions", (IAction)this.getPreviousEventAction());
        manager.appendToGroup("additions", (IAction)this.getNextEventAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getToggleBookmarkAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getPreviousMarkerAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getNextMarkerAction());
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        manager.appendToGroup("additions", (IAction)this.fPreviousItemAction);
        manager.appendToGroup("additions", (IAction)this.fNextItemAction);
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getZoomInAction());
        manager.appendToGroup("additions", (IAction)this.getTimeGraphViewer().getZoomOutAction());
    }

    private Action getNextEventAction() {
        Action nextAction = this.fNextEventAction;
        if (nextAction == null) {
            Action superNextAction = this.getTimeGraphViewer().getNextEventAction();
            nextAction = new Action(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public void run() {
                    TimeGraphViewer viewer = FlameChartView.this.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof TimeGraphEntry) {
                        long selectionBegin;
                        SelectionTimeQueryFilter filter;
                        TimeGraphEntry callStackEntry = (TimeGraphEntry)entry;
                        ITimeGraphDataProvider provider = FlameChartView.getProvider((TimeGraphEntry)callStackEntry);
                        @NonNull TmfModelResponse response = provider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)(filter = new SelectionTimeQueryFilter(selectionBegin = viewer.getSelectionBegin(), Long.MAX_VALUE, 2, Collections.singleton(callStackEntry.getEntryModel().getId())))), null);
                        TimeGraphModel model = (TimeGraphModel)response.getModel();
                        if (model == null || model.getRows().size() != 1) {
                            return;
                        }
                        @NonNull List row = ((ITimeGraphRowModel)model.getRows().get(0)).getStates();
                        if (row.size() != 1) {
                            return;
                        }
                        ITimeGraphState stackInterval = (ITimeGraphState)row.get(0);
                        if (stackInterval.getStartTime() <= selectionBegin && selectionBegin <= stackInterval.getStartTime() + stackInterval.getDuration()) {
                            viewer.setSelectedTimeNotify(stackInterval.getStartTime() + stackInterval.getDuration() + 1L, true);
                        } else {
                            viewer.setSelectedTimeNotify(stackInterval.getStartTime(), true);
                        }
                        int stackLevel = stackInterval.getValue();
                        ITimeGraphEntry selectedEntry = (ITimeGraphEntry)callStackEntry.getParent().getChildren().get(Integer.max(0, stackLevel - 1));
                        viewer.setSelection((ISelection)selectedEntry, true);
                        viewer.getTimeGraphControl().fireSelectionChanged();
                        FlameChartView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                    }
                }
            };
            nextAction.setText(superNextAction.getText());
            nextAction.setToolTipText(superNextAction.getToolTipText());
            nextAction.setImageDescriptor(superNextAction.getImageDescriptor());
            this.fNextEventAction = nextAction;
        }
        return nextAction;
    }

    private Action getPreviousEventAction() {
        Action prevAction = this.fPrevEventAction;
        if (prevAction == null) {
            Action superPrevAction = this.getTimeGraphViewer().getPreviousEventAction();
            prevAction = new Action(){

                /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                public void run() {
                    TimeGraphViewer viewer = FlameChartView.this.getTimeGraphViewer();
                    ITimeGraphEntry entry = viewer.getSelection();
                    if (entry instanceof TimeGraphEntry) {
                        TimeGraphEntry callStackEntry = (TimeGraphEntry)entry;
                        ITimeGraphDataProvider provider = FlameChartView.getProvider((TimeGraphEntry)callStackEntry);
                        long selectionBegin = viewer.getSelectionBegin();
                        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter((List)Lists.newArrayList((Object[])new Long[]{Long.MIN_VALUE, selectionBegin}), Collections.singleton(callStackEntry.getEntryModel().getId()));
                        @NonNull TmfModelResponse response = provider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter), null);
                        TimeGraphModel model = (TimeGraphModel)response.getModel();
                        if (model == null || model.getRows().size() != 1) {
                            return;
                        }
                        @NonNull List row = ((ITimeGraphRowModel)model.getRows().get(0)).getStates();
                        if (row.size() != 1) {
                            return;
                        }
                        ITimeGraphState stackInterval = (ITimeGraphState)row.get(0);
                        viewer.setSelectedTimeNotify(stackInterval.getStartTime(), true);
                        int stackLevel = stackInterval.getValue();
                        ITimeGraphEntry selectedEntry = (ITimeGraphEntry)callStackEntry.getParent().getChildren().get(Integer.max(0, stackLevel - 1));
                        viewer.setSelection((ISelection)selectedEntry, true);
                        viewer.getTimeGraphControl().fireSelectionChanged();
                        FlameChartView.this.startZoomThread(viewer.getTime0(), viewer.getTime1());
                    }
                }
            };
            prevAction.setText(superPrevAction.getText());
            prevAction.setToolTipText(superPrevAction.getToolTipText());
            prevAction.setImageDescriptor(superPrevAction.getImageDescriptor());
            this.fPrevEventAction = prevAction;
        }
        return prevAction;
    }

    protected void setStateTypeNameSupplier(Function<@Nullable ITimeGraphEntry, @Nullable String> resolver) {
        ((BaseDataProviderTimeGraphPresentationProvider)this.getPresentationProvider()).setStateTypeNameResolver(resolver);
    }

    private Action getConfigureSymbolsAction() {
        if (this.fConfigureSymbolsAction != null) {
            return this.fConfigureSymbolsAction;
        }
        Action configureSymbolsAction = new Action(Messages.CallStackView_ConfigureSymbolProvidersText){

            public void run() {
                SymbolProviderConfigDialog dialog = new SymbolProviderConfigDialog(FlameChartView.this.getSite().getShell(), FlameChartView.this.getProviderPages());
                if (dialog.open() == 0) {
                    List traceEntries = FlameChartView.this.getEntryList(FlameChartView.this.getTrace());
                    if (traceEntries != null) {
                        for (BaseDataProviderTimeGraphView.TraceEntry traceEntry : Iterables.filter((Iterable)traceEntries, BaseDataProviderTimeGraphView.TraceEntry.class)) {
                            ITimeGraphDataProvider provider = traceEntry.getProvider();
                            if (provider instanceof CallStackDataProvider) {
                                ((CallStackDataProvider)provider).resetFunctionNames((IProgressMonitor)new NullProgressMonitor());
                            }
                            Iterable flatten = Utils.flatten((TimeGraphEntry)traceEntry);
                            flatten.forEach(e -> e.setSampling(null));
                            long start = traceEntry.getStartTime();
                            long end = traceEntry.getEndTime();
                            long resolution = Long.max(1L, (end - start) / (long)FlameChartView.this.getDisplayWidth());
                            FlameChartView.this.zoomEntries(flatten, start, end, resolution, (IProgressMonitor)new NullProgressMonitor());
                        }
                        FlameChartView.this.refresh();
                    }
                    FlameChartView.this.synchingToTime(FlameChartView.this.getTimeGraphViewer().getSelectionBegin());
                }
            }
        };
        configureSymbolsAction.setToolTipText(Messages.CallStackView_ConfigureSymbolProvidersTooltip);
        configureSymbolsAction.setImageDescriptor(Objects.requireNonNull(Activator.getDefault()).getImageDescripterFromPath(IMPORT_BINARY_ICON_PATH));
        configureSymbolsAction.setEnabled(false);
        this.fConfigureSymbolsAction = configureSymbolsAction;
        return configureSymbolsAction;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private ISymbolProviderPreferencePage[] getProviderPages() {
        ArrayList<ISymbolProviderPreferencePage> pages = new ArrayList<ISymbolProviderPreferencePage>();
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            for (ITmfTrace subTrace : this.getTracesToBuild(trace)) {
                @NonNull Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(subTrace);
                for (ISymbolProvider provider : Iterables.filter((Iterable)symbolProviders, ISymbolProvider.class)) {
                    ISymbolProviderPreferencePage page = provider.createPreferencePage();
                    if (page == null) continue;
                    pages.add(page);
                }
            }
        }
        return pages.toArray(new ISymbolProviderPreferencePage[pages.size()]);
    }

    private void updateConfigureSymbolsAction() {
        ISymbolProviderPreferencePage[] providerPages = this.getProviderPages();
        this.getConfigureSymbolsAction().setEnabled(providerPages.length > 0);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        @NonNull List traceEntries = this.getEntryList(Objects.requireNonNull(signal).getTrace());
        if (traceEntries != null) {
            Iterable all = Iterables.concat((Iterable)Iterables.transform((Iterable)traceEntries, Utils::flatten));
            all.forEach(entry -> {
                ITimeGraphState iTimeGraphState = this.fFunctions.remove(entry.getEntryModel().getId());
            });
        }
        super.traceClosed(signal);
    }

    private class CallStackComparator
    implements Comparator<ITimeGraphEntry> {
        private CallStackComparator() {
        }

        @Override
        public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
            if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
                TimeGraphEntry t1 = (TimeGraphEntry)o1;
                TimeGraphEntry t2 = (TimeGraphEntry)o2;
                ITmfTreeDataModel model1 = t1.getEntryModel();
                ITmfTreeDataModel model2 = t2.getEntryModel();
                CallStackEntryModel m1 = (CallStackEntryModel)model1;
                CallStackEntryModel m2 = (CallStackEntryModel)model2;
                if (m1.getStackLevel() == 0 && m2.getStackLevel() == 0) {
                    return NAME_COMPARATOR.compare((ITimeGraphEntry)t1, (ITimeGraphEntry)t2);
                }
                if (m1.getStackLevel() == -1 && m2.getStackLevel() == -1) {
                    return Integer.compare(m1.getPid(), m2.getPid());
                }
            }
            return 0;
        }
    }

    private class CallStackTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private CallStackTreeLabelProvider() {
        }

        public @Nullable Image getColumnImage(@Nullable Object element, int columnIndex) {
            TimeGraphEntry entry;
            ITmfTreeDataModel entryModel;
            if (columnIndex == 0 && element instanceof TimeGraphEntry && (entryModel = (entry = (TimeGraphEntry)element).getEntryModel()) instanceof CallStackEntryModel) {
                CallStackEntryModel callStackEntryModel = (CallStackEntryModel)entryModel;
                if (callStackEntryModel.getStackLevel() == -1) {
                    return PROCESS_IMAGE;
                }
                if (callStackEntryModel.getStackLevel() == 0) {
                    return THREAD_IMAGE;
                }
                if (FlameChartView.this.fFunctions.containsKey(entryModel.getId())) {
                    return STACKFRAME_IMAGE;
                }
            }
            return null;
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            if (element instanceof BaseDataProviderTimeGraphView.TraceEntry && columnIndex == 0) {
                return String.valueOf(((BaseDataProviderTimeGraphView.TraceEntry)element).getName());
            }
            if (element instanceof TimeGraphEntry) {
                TimeGraphEntry entry = (TimeGraphEntry)element;
                ITmfTreeDataModel model = entry.getEntryModel();
                ITimeGraphState function = FlameChartView.this.fFunctions.get(model.getId());
                if (columnIndex == 0 && (!(model instanceof CallStackEntryModel) || model instanceof CallStackEntryModel && ((CallStackEntryModel)model).getStackLevel() <= 0)) {
                    return String.valueOf(entry.getName());
                }
                if (function != null) {
                    if (columnIndex == 0) {
                        return String.valueOf(function.getLabel());
                    }
                    if (columnIndex == 2 && model instanceof CallStackEntryModel) {
                        return Integer.toString(((CallStackEntryModel)model).getStackLevel());
                    }
                    if (columnIndex == 3) {
                        return String.valueOf(TmfTimestampFormat.getDefaulTimeFormat().format(function.getStartTime()));
                    }
                    if (columnIndex == 4) {
                        return String.valueOf(TmfTimestampFormat.getDefaulTimeFormat().format(function.getStartTime() + function.getDuration()));
                    }
                    if (columnIndex == 5) {
                        return String.valueOf(TmfTimestampFormat.getDefaulIntervalFormat().format(function.getDuration()));
                    }
                } else if (model instanceof CallStackEntryModel) {
                    CallStackEntryModel callStackEntryModel = (CallStackEntryModel)model;
                    if (columnIndex == 1 && callStackEntryModel.getStackLevel() <= 0 && callStackEntryModel.getPid() >= 0) {
                        return Integer.toString(callStackEntryModel.getPid());
                    }
                    if (columnIndex == 3 && callStackEntryModel.getStackLevel() <= 0) {
                        return String.valueOf(TmfTimestampFormat.getDefaulTimeFormat().format(callStackEntryModel.getStartTime()));
                    }
                    if (columnIndex == 4 && callStackEntryModel.getStackLevel() <= 0) {
                        return String.valueOf(TmfTimestampFormat.getDefaulTimeFormat().format(callStackEntryModel.getEndTime()));
                    }
                }
            }
            return "";
        }
    }
}

