/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.remote.core.tests.shell;

import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.remote.core.shell.CommandResult;
import org.junit.Assert;
import org.junit.Test;

public class CommandResultTest {
    private static final @NonNull String @NonNull [] CMD_OUTPUT = new String[]{"This", "is", "the", "output"};
    private static final @NonNull String @NonNull [] CMD_NO_ERROR_OUTPUT = new String[0];
    private static final @NonNull String @NonNull [] CMD_ERROR_OUTPUT = new String[]{"This", "is", "the", "error", "output"};

    @Test
    public void testConstructorNoError() {
        CommandResult result = new CommandResult(0, CMD_OUTPUT, CMD_NO_ERROR_OUTPUT);
        Assert.assertEquals((long)0L, (long)result.getResult());
        Assert.assertEquals(Arrays.asList(CMD_OUTPUT), (Object)result.getOutput());
        Assert.assertEquals(Arrays.asList(CMD_NO_ERROR_OUTPUT), (Object)result.getErrorOutput());
        String expected = CommandResultTest.expectedResultString(0, CMD_OUTPUT, CMD_NO_ERROR_OUTPUT);
        Assert.assertEquals((Object)expected, (Object)result.toString());
    }

    @Test
    public void testConstructorError() {
        CommandResult result = new CommandResult(1, CMD_OUTPUT, CMD_ERROR_OUTPUT);
        Assert.assertEquals((long)1L, (long)result.getResult());
        Assert.assertEquals(Arrays.asList(CMD_OUTPUT), (Object)result.getOutput());
        Assert.assertEquals(Arrays.asList(CMD_ERROR_OUTPUT), (Object)result.getErrorOutput());
        String expected = CommandResultTest.expectedResultString(1, CMD_OUTPUT, CMD_ERROR_OUTPUT);
        Assert.assertEquals((Object)expected, (Object)result.toString());
    }

    private static String expectedResultString(int result, String[] output, String[] errorOutput) {
        String string;
        StringBuffer expected = new StringBuffer();
        expected.append("Error Output:\n");
        String[] stringArray = errorOutput;
        int n = errorOutput.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            expected.append(string).append("\n");
            ++n2;
        }
        expected.append("Return Value: ").append(result).append("\n");
        stringArray = output;
        n = output.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            expected.append(string).append("\n");
            ++n2;
        }
        return expected.toString();
    }
}

