/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;

public class ZoomEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    @Override
    public int getEvent() {
        return 2;
    }

    @Override
    public int getButton() {
        return 4;
    }

    @Override
    public int getStateMask() {
        return 0;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        IAxisSet axisSet = baseChart.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        IAxis yAxis = axisSet.getYAxis(0);
        RangeRestriction rangeRestriction = baseChart.getRangeRestriction();
        if (baseChart.isZoomXAndY(rangeRestriction)) {
            baseChart.zoomX(xAxis, event);
            baseChart.zoomY(yAxis, event);
        } else if (rangeRestriction.isXZoomOnly()) {
            baseChart.zoomX(xAxis, event);
        } else if (rangeRestriction.isYZoomOnly()) {
            baseChart.zoomY(yAxis, event);
        }
        if (rangeRestriction.isRestrictZoom()) {
            Range rangeX = xAxis.getRange();
            Range rangeY = yAxis.getRange();
            baseChart.setRange(xAxis, rangeX.lower, rangeX.upper, true);
            baseChart.setRange(yAxis, rangeY.lower, rangeY.upper, true);
        } else {
            baseChart.adjustSecondaryXAxes();
            baseChart.adjustSecondaryYAxes();
        }
        baseChart.fireUpdateCustomRangeSelectionHandlers(event);
        baseChart.redraw();
    }
}

