/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.building;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.building.ITmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathModule;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.ICriticalPathProvider;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class TmfGraphBuilderModule
extends TmfAbstractAnalysisModule
implements ICriticalPathProvider {
    private @Nullable TmfGraph fGraph;
    private @Nullable ITmfEventRequest fRequest;
    private final CriticalPathModule fCriticalPathModule = new CriticalPathModule(this);

    protected abstract ITmfGraphProvider getGraphProvider();

    public @Nullable TmfGraph getGraph() {
        return this.fGraph;
    }

    protected boolean executeAnalysis(IProgressMonitor monitor) {
        if (this.fGraph == null) {
            ITmfGraphProvider provider = this.getGraphProvider();
            this.createGraph(provider);
        }
        return !monitor.isCanceled();
    }

    public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
        boolean ret = super.setTrace(trace);
        if (!ret) {
            return ret;
        }
        ret = this.fCriticalPathModule.setTrace(trace);
        return ret;
    }

    protected void canceling() {
        ITmfEventRequest req = this.fRequest;
        if (req != null && !req.isCompleted()) {
            req.cancel();
        }
    }

    public void dispose() {
        this.fCriticalPathModule.dispose();
        super.dispose();
    }

    private void createGraph(ITmfGraphProvider provider) {
        this.fGraph = new TmfGraph();
        provider.assignTargetGraph(this.fGraph);
        this.build(provider);
    }

    private void build(ITmfGraphProvider provider) {
        Object request = this.fRequest;
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
        try {
            this.fRequest = request = new TmfGraphBuildRequest(provider);
            provider.getTrace().sendRequest(request);
            request.waitForCompletion();
        }
        catch (InterruptedException e) {
            Activator.getInstance().logError("Request interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public @Nullable TmfGraph getCriticalPath() {
        return this.fCriticalPathModule.getCriticalPath();
    }

    private static class TmfGraphBuildRequest
    extends TmfEventRequest {
        private final ITmfGraphProvider fProvider;

        public TmfGraphBuildRequest(ITmfGraphProvider provider) {
            super(TmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.fProvider = provider;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            this.fProvider.processEvent(event);
        }

        public synchronized void done() {
            super.done();
            this.fProvider.done();
        }

        public void handleCancel() {
            this.fProvider.handleCancel();
            super.handleCancel();
        }
    }
}

