/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsChangeListener;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFileDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsExtensionManager;
import org.eclipse.cdt.internal.core.language.settings.providers.LanguageSettingsProvidersSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class LanguageSettingsManager {
    public static List<ICLanguageSettingEntry> getSettingEntriesByKind(ICConfigurationDescription cfgDescription, IResource rc, String languageId, int kind) {
        return LanguageSettingsProvidersSerializer.getSettingEntriesByKind(cfgDescription, rc, languageId, kind);
    }

    public static List<ICLanguageSettingEntry> getSettingEntriesUpResourceTree(ILanguageSettingsProvider provider, ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        return LanguageSettingsProvidersSerializer.getSettingEntriesUpResourceTree(provider, cfgDescription, rc, languageId);
    }

    public static ILanguageSettingsProvider getWorkspaceProvider(String id) {
        return LanguageSettingsProvidersSerializer.getWorkspaceProvider(id);
    }

    public static List<ILanguageSettingsProvider> getWorkspaceProviders() {
        return LanguageSettingsProvidersSerializer.getWorkspaceProviders();
    }

    public static boolean isWorkspaceProvider(ILanguageSettingsProvider provider) {
        return LanguageSettingsProvidersSerializer.isWorkspaceProvider(provider);
    }

    public static ILanguageSettingsProvider getRawProvider(ILanguageSettingsProvider provider) {
        if (LanguageSettingsManager.isWorkspaceProvider(provider)) {
            provider = LanguageSettingsProvidersSerializer.getRawWorkspaceProvider(provider.getId());
        }
        return provider;
    }

    public static void setWorkspaceProviders(List<ILanguageSettingsProvider> providers) throws CoreException {
        LanguageSettingsProvidersSerializer.setWorkspaceProviders(providers);
    }

    public static ILanguageSettingsEditableProvider getProviderCopy(ILanguageSettingsEditableProvider provider, boolean deep) {
        return LanguageSettingsExtensionManager.getProviderCopy(provider, deep);
    }

    public static Set<String> getExtensionProviderIds() {
        return LanguageSettingsExtensionManager.getExtensionProviderIds();
    }

    public static ILanguageSettingsProvider getExtensionProviderCopy(String id, boolean deep) {
        return LanguageSettingsExtensionManager.getExtensionProviderCopy(id, deep);
    }

    public static boolean isEqualExtensionProvider(ILanguageSettingsProvider provider, boolean deep) {
        return LanguageSettingsExtensionManager.isEqualExtensionProvider(provider, deep);
    }

    public static List<String> getLanguages(ICResourceDescription rcDescription) {
        ICLanguageSetting[] languageSettings = null;
        if (rcDescription instanceof ICFileDescription) {
            ICLanguageSetting languageSetting = ((ICFileDescription)rcDescription).getLanguageSetting();
            if (languageSetting != null) {
                languageSettings = new ICLanguageSetting[]{languageSetting};
            }
        } else if (rcDescription instanceof ICFolderDescription) {
            languageSettings = ((ICFolderDescription)rcDescription).getLanguageSettings();
        }
        ArrayList<String> languageIds = new ArrayList<String>();
        if (languageSettings != null) {
            ICLanguageSetting[] iCLanguageSettingArray = languageSettings;
            int n = languageSettings.length;
            int n2 = 0;
            while (n2 < n) {
                String languageId;
                ICLanguageSetting languageSetting = iCLanguageSettingArray[n2];
                if (languageSetting != null && !languageIds.contains(languageId = languageSetting.getLanguageId())) {
                    languageIds.add(languageId);
                }
                ++n2;
            }
        }
        return languageIds;
    }

    public static List<String> getLanguages(IResource resource, ICConfigurationDescription cfgDescription) {
        List<String> languageIds = new ArrayList<String>();
        IPath prjRelPath = resource.getProjectRelativePath();
        if (resource instanceof IFile) {
            ICLanguageSetting ls;
            String langId = null;
            if (cfgDescription != null && (ls = cfgDescription.getLanguageSettingForFile(prjRelPath, true)) != null) {
                langId = ls.getLanguageId();
            }
            if (langId == null) {
                try {
                    ILanguage lang = LanguageManager.getInstance().getLanguageForFile((IFile)resource, cfgDescription);
                    if (lang != null) {
                        langId = lang.getId();
                    }
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            if (langId != null) {
                languageIds.add(langId);
            }
        } else {
            ICResourceDescription rcDes = cfgDescription.getResourceDescription(prjRelPath, false);
            if (rcDes == null) {
                rcDes = cfgDescription.getRootFolderDescription();
            }
            languageIds = LanguageSettingsManager.getLanguages(rcDes);
        }
        return languageIds;
    }

    public static void registerLanguageSettingsChangeListener(ILanguageSettingsChangeListener listener) {
        LanguageSettingsProvidersSerializer.registerLanguageSettingsChangeListener(listener);
    }

    public static void unregisterLanguageSettingsChangeListener(ILanguageSettingsChangeListener listener) {
        LanguageSettingsProvidersSerializer.unregisterLanguageSettingsChangeListener(listener);
    }

    public static boolean isPreferShared(String id) {
        return LanguageSettingsExtensionManager.isPreferShared(id);
    }

    public static boolean isStoringEntriesInProjectArea(LanguageSettingsSerializableProvider provider) {
        return LanguageSettingsProvidersSerializer.isStoringEntriesInProjectArea(provider);
    }

    public static void setStoringEntriesInProjectArea(LanguageSettingsSerializableProvider provider, boolean storeEntriesWithProject) {
        LanguageSettingsProvidersSerializer.setStoringEntriesInProjectArea(provider, storeEntriesWithProject);
    }

    public static void serializeLanguageSettings(ICProjectDescription prjDescription) throws CoreException {
        LanguageSettingsProvidersSerializer.serializeLanguageSettings(prjDescription);
    }

    public static void serializeLanguageSettingsWorkspace() throws CoreException {
        LanguageSettingsProvidersSerializer.serializeLanguageSettingsWorkspace();
    }

    public static void serializeLanguageSettingsInBackground(ICProjectDescription prjDescription) {
        LanguageSettingsProvidersSerializer.serializeLanguageSettingsInBackground(prjDescription);
    }

    public static void serializeLanguageSettingsWorkspaceInBackground() {
        LanguageSettingsProvidersSerializer.serializeLanguageSettingsWorkspaceInBackground();
    }

    public static List<ILanguageSettingsProvider> createLanguageSettingsProviders(String[] ids) {
        ArrayList<ILanguageSettingsProvider> providers = new ArrayList<ILanguageSettingsProvider>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ILanguageSettingsProvider provider = null;
            if (!LanguageSettingsManager.isPreferShared(id)) {
                provider = LanguageSettingsManager.getExtensionProviderCopy(id, false);
            }
            if (provider == null) {
                provider = LanguageSettingsManager.getWorkspaceProvider(id);
            }
            providers.add(provider);
            ++n2;
        }
        return providers;
    }
}

