/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.trace.layout.Lttng27EventLayout;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisFactoryException;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysisFactoryFromConfigFile;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.OnDemandAnalysisManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

final class LttngAnalysesLoader {
    private static final String CONFIG_DIR_NAME = "lttng-analyses-configs";

    private LttngAnalysesLoader() {
    }

    private static boolean appliesTo(ITmfTrace trace) {
        LttngKernelTrace kernelTrace;
        IKernelAnalysisEventLayout layout;
        return trace instanceof LttngKernelTrace && (layout = (kernelTrace = (LttngKernelTrace)trace).getKernelEventLayout()) instanceof Lttng27EventLayout;
    }

    private static String[] getAnalysisNames() throws IOException {
        ClassLoader loader = LttngAnalysesLoader.class.getClassLoader();
        String path = "/lttng-analyses-configs/index.properties";
        String[] names = new String[]{};
        Properties indexProps = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = loader.getResourceAsStream("/lttng-analyses-configs/index.properties");){
            if (in == null) {
                return names;
            }
            indexProps.load(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String analyses = indexProps.getProperty("analyses");
        if (analyses == null) {
            return names;
        }
        analyses = analyses.trim();
        return analyses.split("\\s+");
    }

    public static void load() throws LamiAnalysisFactoryException, IOException {
        String[] names = LttngAnalysesLoader.getAnalysisNames();
        ClassLoader loader = LttngAnalysesLoader.class.getClassLoader();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String path = String.format("/%s/%s.properties", CONFIG_DIR_NAME, name);
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStream in = loader.getResourceAsStream(path);){
                if (in != null) {
                    LamiAnalysis analysis = LamiAnalysisFactoryFromConfigFile.buildFromInputStream((InputStream)in, (boolean)false, LttngAnalysesLoader::appliesTo);
                    OnDemandAnalysisManager.getInstance().registerAnalysis((IOnDemandAnalysis)analysis);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
    }
}

