/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.counters.core;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.CounterAnalysis;
import org.eclipse.tracecompass.internal.analysis.counters.core.CounterDataProvider;
import org.eclipse.tracecompass.internal.analysis.counters.core.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CounterDataProviderFactory
implements IDataProviderFactory {
    private static final String TITLE = Objects.requireNonNull(Messages.CounterDataProvider_ChartTitle);
    private static final Predicate<? super ITmfTrace> PREDICATE = t -> !Iterables.isEmpty((Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)t, CounterAnalysis.class));
    private static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId("org.eclipse.tracecompass.analysis.counters.core.CounterDataProvider").setName(TITLE).setDescription(Objects.requireNonNull(Messages.CounterDataProviderFactory_DescriptionText)).setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY).build();

    public @Nullable ITmfTreeXYDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        if (traces.size() == 1) {
            ArrayList<CounterDataProvider> dataProviders = new ArrayList<CounterDataProvider>();
            for (CounterAnalysis module : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CounterAnalysis.class)) {
                ITmfTrace subTrace = module.getTrace();
                CounterDataProvider provider = CounterDataProvider.create(Objects.requireNonNull(subTrace), module);
                if (provider == null) continue;
                dataProviders.add(provider);
            }
            if (dataProviders.isEmpty()) {
                return null;
            }
            if (dataProviders.size() == 1) {
                return (ITmfTreeXYDataProvider)dataProviders.get(0);
            }
            return new TmfTreeXYCompositeDataProvider(dataProviders, TITLE, "org.eclipse.tracecompass.analysis.counters.core.CounterDataProvider");
        }
        return TmfTreeXYCompositeDataProvider.create((Collection)traces, (String)TITLE, (String)"org.eclipse.tracecompass.analysis.counters.core.CounterDataProvider");
    }

    public Collection<IDataProviderDescriptor> getDescriptors(@NonNull ITmfTrace trace) {
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        return Iterables.any((Iterable)traces, PREDICATE) ? Collections.singletonList(DESCRIPTOR) : Collections.emptyList();
    }
}

