/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import com.google.common.base.Objects;
import java.io.IOException;
import java.net.URL;
import java.util.function.Predicate;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.TableCollection;
import org.eclipse.swtbot.swt.finder.utils.TableRow;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class BookmarksViewTest {
    private static final Logger fLogger = Logger.getRootLogger();
    private static final String PROJECT_NAME = "TestBookmarks";
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.tmf.core.tests.secondtt";
    private static final String BOOKMARK_NAME = "banana";
    private static final @NonNull String EXPERIMENT_NAME = "experiment";
    private static final Predicate<SWTBotTable> TABLE_NOT_EMPTY = tb -> tb.rowCount() > 2;
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.switchToTracingPerspective();
        WaitUtils.waitForJobs();
    }

    @Before
    public void beforeTest() {
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder(fBot, PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
    }

    @Test
    @Ignore
    public void testTrace() throws IOException {
        SWTBotUtils.openTrace(PROJECT_NAME, FileLocator.toFileURL((URL)TmfTraceStub.class.getResource("/testfiles/A-Test-10K")).getPath(), TRACE_TYPE);
        BookmarksViewTest.bookmarkTest("A-Test-10K");
    }

    @Test
    @Ignore
    public void testExperiment() throws IOException {
        SWTBotUtils.openTrace(PROJECT_NAME, FileLocator.toFileURL((URL)TmfTraceStub.class.getResource("/testfiles/A-Test-10K")).getPath(), TRACE_TYPE);
        SWTBotUtils.openTrace(PROJECT_NAME, FileLocator.toFileURL((URL)TmfTraceStub.class.getResource("/testfiles/A-Test-10K-2")).getPath(), TRACE_TYPE);
        WaitUtils.waitForJobs();
        SWTBotUtils.createExperiment(fBot, PROJECT_NAME, EXPERIMENT_NAME);
        SWTBotTreeItem project = SWTBotUtils.selectProject(fBot, PROJECT_NAME);
        SWTBotTreeItem experiment = SWTBotUtils.getTraceProjectItem((SWTBot)fBot, project, "Experiments", EXPERIMENT_NAME);
        experiment.contextMenu("Select Traces...").click();
        SWTBotShell selectTracesShell = fBot.shell("Select Traces");
        selectTracesShell.bot().button("Select All").click();
        selectTracesShell.bot().button("Finish").click();
        experiment.select();
        experiment.doubleClick();
        SWTBotEditor editor = SWTBotUtils.activeEventsEditor(fBot, EXPERIMENT_NAME);
        Assert.assertEquals((String)"Event editor is displaying the wrong trace/experiment", (Object)EXPERIMENT_NAME, (Object)editor.getTitle());
        BookmarksViewTest.bookmarkTest(EXPERIMENT_NAME);
    }

    private static void bookmarkTest(String editorName) throws IOException {
        SWTBotView fViewBot = fBot.viewByPartName("Bookmarks");
        fViewBot.setFocus();
        WaitUtils.waitForJobs();
        Assert.assertEquals((String)"Failed to show the Bookmarks View", (Object)"Bookmarks", (Object)fViewBot.getTitle());
        SWTBotEditor editorBot = SWTBotUtils.activateEditor(fBot, editorName);
        SWTBotTable tableBot = editorBot.bot().table();
        SWTBotTableItem tableItem = tableBot.getTableItem(7);
        String expectedTimeStamp = tableItem.getText(1);
        Assert.assertNull((String)"The image should not be bookmarked yet", (Object)BookmarksViewTest.getBookmarkImage(tableItem));
        tableItem.select();
        tableItem.doubleClick();
        fBot.menu("Edit").menu("Add Bookmark...").click();
        WaitUtils.waitForJobs();
        SWTBotShell addBookmarkShell = fBot.shell("Add Bookmark");
        addBookmarkShell.bot().text().setText(BOOKMARK_NAME);
        addBookmarkShell.bot().button("OK").click();
        Assert.assertNotNull((String)"Failed to add bookmark in event editor", (Object)BookmarksViewTest.getBookmarkImage(tableItem));
        fViewBot.setFocus();
        WaitUtils.waitForJobs();
        SWTBotTree bookmarkTree = fViewBot.bot().tree();
        WaitUtils.waitForJobs();
        SWTBotTreeItem bookmark = bookmarkTree.getTreeItem(BOOKMARK_NAME);
        Assert.assertEquals((Object)BOOKMARK_NAME, (Object)bookmark.cell(0));
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal(null, TmfTimestamp.fromMicros((long)22L))));
        bookmark.doubleClick();
        WaitUtils.waitUntil(TABLE_NOT_EMPTY, (Object)tableBot, (String)"Table is still empty");
        TableCollection selection = tableBot.selection();
        TableRow row = selection.get(0);
        Assert.assertNotNull((String)selection.toString(), (Object)row);
        Assert.assertEquals((String)("Wrong event was selected " + selection), (Object)expectedTimeStamp, (Object)row.get(1));
        SWTBotUtils.openTrace(PROJECT_NAME, FileLocator.toFileURL((URL)TmfTraceStub.class.getResource("/testfiles/E-Test-10K")).getPath(), TRACE_TYPE);
        WaitUtils.waitForJobs();
        bookmark.doubleClick();
        editorBot = SWTBotUtils.activeEventsEditor(fBot, editorName);
        WaitUtils.waitUntil(TABLE_NOT_EMPTY, (Object)tableBot, (String)"Table is still empty");
        selection = tableBot.selection();
        row = selection.get(0);
        Assert.assertNotNull((String)selection.toString(), (Object)row);
        Assert.assertEquals((String)("Wrong event was selected " + selection), (Object)expectedTimeStamp, (Object)row.get(1));
        editorBot.close();
        WaitUtils.waitUntil(eb -> !eb.isActive(), (Object)editorBot, (String)"Waiting for the editor to close");
        bookmark.doubleClick();
        editorBot = SWTBotUtils.activeEventsEditor(fBot, editorName);
        WaitUtils.waitUntil(eb -> eb.bot().table().selection().rowCount() > 0, (Object)editorBot, (String)"Selection is still empty");
        tableBot = editorBot.bot().table();
        WaitUtils.waitUntil(tb -> !Objects.equal((Object)tb.selection().get(0).get(1), (Object)"<srch>"), (Object)tableBot, (String)"Header is still selected");
        selection = tableBot.selection();
        row = selection.get(0);
        Assert.assertNotNull((String)selection.toString(), (Object)row);
        Assert.assertEquals((String)("Wrong event was selected " + selection), (Object)expectedTimeStamp, (Object)row.get(1));
        bookmark.select();
        bookmark.contextMenu("Delete").click();
        SWTBotShell deleteBookmarkShell = fBot.shell("Delete Selected Entries");
        SWTBotUtils.anyButtonOf(deleteBookmarkShell.bot(), "Delete", "Yes").click();
        fBot.waitUntil(Conditions.treeHasRows((SWTBotTree)bookmarkTree, (int)0));
        tableItem = editorBot.bot().table().getTableItem(7);
        Assert.assertNull((String)"Bookmark not deleted from event table", (Object)BookmarksViewTest.getBookmarkImage(tableItem));
    }

    private static Image getBookmarkImage(SWTBotTableItem tableItem) {
        return (Image)UIThreadRunnable.syncExec(() -> ((TableItem)sWTBotTableItem.widget).getImage(0));
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
    }

    @AfterClass
    public static void cleanUp() {
        fLogger.removeAllAppenders();
    }
}

