/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer.checkpoint;

import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.junit.Assert;
import org.junit.Test;

public class TmfCheckpointTest {
    private ITmfTimestamp fTimestamp1 = TmfTimestamp.fromSeconds((long)0L);
    private ITmfTimestamp fTimestamp2 = TmfTimestamp.BIG_BANG;
    private ITmfTimestamp fTimestamp3 = TmfTimestamp.BIG_CRUNCH;
    private long aLong1 = 12345L;
    private long aLong2 = 23456L;
    private long aLong3 = 34567L;
    private long RANK1 = 1L;
    private long RANK2 = 2L;
    private long RANK3 = 3L;
    private ITmfLocation fLocation1 = new TmfLongLocation(this.aLong1);
    private ITmfLocation fLocation2 = new TmfLongLocation(this.aLong2);
    private ITmfLocation fLocation3 = new TmfLongLocation(this.aLong3);
    private TmfCheckpoint fCheckpoint1 = new TmfCheckpoint(this.fTimestamp1, this.fLocation1, this.RANK1);
    private TmfCheckpoint fCheckpoint2 = new TmfCheckpoint(this.fTimestamp2, this.fLocation2, this.RANK2);
    private TmfCheckpoint fCheckpoint3 = new TmfCheckpoint(this.fTimestamp3, this.fLocation3, this.RANK3);

    @Test
    public void testTmfCheckpoint() {
        Assert.assertEquals((String)"TmfCheckpoint", (Object)this.fTimestamp1, (Object)this.fCheckpoint1.getTimestamp());
        Assert.assertEquals((String)"TmfCheckpoint", (Object)this.fLocation1, (Object)this.fCheckpoint1.getLocation());
    }

    public void testTmfLocationCopy() {
        TmfCheckpoint checkpoint = new TmfCheckpoint(this.fCheckpoint1);
        Assert.assertEquals((String)"TmfCheckpoint", (Object)this.fTimestamp1, (Object)checkpoint.getTimestamp());
        Assert.assertEquals((String)"TmfCheckpoint", (Object)this.fLocation1, (Object)checkpoint.getLocation());
    }

    @Test
    public void testTmfLocationCopy2() {
        try {
            new TmfCheckpoint(null);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"wrong exception");
        }
    }

    @Test
    public void testCompareTo() {
        Assert.assertEquals((String)"compareTo", (long)0L, (long)this.fCheckpoint1.compareTo((ITmfCheckpoint)this.fCheckpoint1));
        Assert.assertEquals((String)"compareTo", (long)1L, (long)this.fCheckpoint1.compareTo((ITmfCheckpoint)this.fCheckpoint2));
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)this.fCheckpoint1.compareTo((ITmfCheckpoint)this.fCheckpoint3));
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)this.fCheckpoint2.compareTo((ITmfCheckpoint)this.fCheckpoint1));
        Assert.assertEquals((String)"compareTo", (long)0L, (long)this.fCheckpoint2.compareTo((ITmfCheckpoint)this.fCheckpoint2));
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)this.fCheckpoint2.compareTo((ITmfCheckpoint)this.fCheckpoint3));
        Assert.assertEquals((String)"compareTo", (long)1L, (long)this.fCheckpoint3.compareTo((ITmfCheckpoint)this.fCheckpoint1));
        Assert.assertEquals((String)"compareTo", (long)1L, (long)this.fCheckpoint3.compareTo((ITmfCheckpoint)this.fCheckpoint2));
        Assert.assertEquals((String)"compareTo", (long)0L, (long)this.fCheckpoint3.compareTo((ITmfCheckpoint)this.fCheckpoint3));
    }

    @Test
    public void testCompareToNull() {
        TmfCheckpoint checkpoint1 = new TmfCheckpoint(null, this.fLocation1, this.RANK1);
        TmfCheckpoint checkpoint2 = new TmfCheckpoint(null, this.fLocation2, this.RANK2);
        TmfCheckpoint checkpoint3 = new TmfCheckpoint(null, this.fLocation3, this.RANK3);
        TmfCheckpoint checkpoint4 = new TmfCheckpoint(null, this.fLocation1, this.RANK1);
        Assert.assertEquals((String)"compareTo", (long)0L, (long)checkpoint1.compareTo((ITmfCheckpoint)this.fCheckpoint1));
        Assert.assertEquals((String)"compareTo", (long)0L, (long)this.fCheckpoint1.compareTo((ITmfCheckpoint)checkpoint1));
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)checkpoint1.compareTo((ITmfCheckpoint)this.fCheckpoint2));
        Assert.assertEquals((String)"compareTo", (long)1L, (long)this.fCheckpoint2.compareTo((ITmfCheckpoint)checkpoint1));
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)checkpoint1.compareTo((ITmfCheckpoint)this.fCheckpoint3));
        Assert.assertEquals((String)"compareTo", (long)1L, (long)this.fCheckpoint3.compareTo((ITmfCheckpoint)checkpoint1));
        Assert.assertEquals((String)"compareTo", (long)0L, (long)checkpoint1.compareTo((ITmfCheckpoint)checkpoint4));
        Assert.assertEquals((String)"compareTo", (long)0L, (long)checkpoint4.compareTo((ITmfCheckpoint)checkpoint1));
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)checkpoint1.compareTo((ITmfCheckpoint)checkpoint2));
        Assert.assertEquals((String)"compareTo", (long)1L, (long)checkpoint2.compareTo((ITmfCheckpoint)checkpoint1));
        Assert.assertEquals((String)"compareTo", (long)-1L, (long)checkpoint1.compareTo((ITmfCheckpoint)checkpoint3));
        Assert.assertEquals((String)"compareTo", (long)1L, (long)checkpoint3.compareTo((ITmfCheckpoint)checkpoint1));
    }

    @Test
    public void testHashCode() {
        TmfCheckpoint checkpoint1 = new TmfCheckpoint(this.fCheckpoint1);
        TmfCheckpoint checkpoint2 = new TmfCheckpoint(this.fCheckpoint2);
        Assert.assertTrue((String)"hashCode", (this.fCheckpoint1.hashCode() == checkpoint1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fCheckpoint2.hashCode() == checkpoint2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fCheckpoint1.hashCode() != checkpoint2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fCheckpoint2.hashCode() != checkpoint1.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testHashCodeNull() {
        TmfCheckpoint checkpoint1 = new TmfCheckpoint(null, this.fLocation1, this.RANK1);
        TmfCheckpoint checkpoint2 = new TmfCheckpoint(this.fTimestamp1, null, this.RANK1);
        TmfCheckpoint checkpoint3 = new TmfCheckpoint(checkpoint1);
        TmfCheckpoint checkpoint4 = new TmfCheckpoint(checkpoint2);
        Assert.assertTrue((String)"hashCode", (this.fCheckpoint1.hashCode() != checkpoint1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fCheckpoint1.hashCode() != checkpoint2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (checkpoint1.hashCode() == checkpoint3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (checkpoint2.hashCode() == checkpoint4.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fCheckpoint1.equals((Object)this.fCheckpoint1));
        Assert.assertTrue((String)"equals", (boolean)this.fCheckpoint2.equals((Object)this.fCheckpoint2));
        Assert.assertTrue((String)"equals", (!this.fCheckpoint1.equals((Object)this.fCheckpoint2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fCheckpoint2.equals((Object)this.fCheckpoint1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TmfCheckpoint checkpoint1 = new TmfCheckpoint(this.fCheckpoint1);
        TmfCheckpoint checkpoint2 = new TmfCheckpoint(this.fCheckpoint2);
        Assert.assertTrue((String)"equals", (boolean)checkpoint1.equals((Object)this.fCheckpoint1));
        Assert.assertTrue((String)"equals", (boolean)this.fCheckpoint1.equals((Object)checkpoint1));
        Assert.assertTrue((String)"equals", (boolean)checkpoint2.equals((Object)this.fCheckpoint2));
        Assert.assertTrue((String)"equals", (boolean)this.fCheckpoint2.equals((Object)checkpoint2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfCheckpoint checkpoint1 = new TmfCheckpoint(this.fCheckpoint1);
        TmfCheckpoint checkpoint2 = new TmfCheckpoint(checkpoint1);
        TmfCheckpoint checkpoint3 = new TmfCheckpoint(checkpoint2);
        Assert.assertTrue((String)"equals", (boolean)checkpoint1.equals((Object)checkpoint2));
        Assert.assertTrue((String)"equals", (boolean)checkpoint2.equals((Object)checkpoint3));
        Assert.assertTrue((String)"equals", (boolean)checkpoint1.equals((Object)checkpoint3));
    }

    @Test
    public void testNotEqual() {
        TmfCheckpoint checkpoint1 = new TmfCheckpoint(this.fTimestamp1, this.fLocation1, this.RANK1);
        TmfCheckpoint checkpoint2 = new TmfCheckpoint(this.fTimestamp2, this.fLocation1, this.RANK1);
        TmfCheckpoint checkpoint3 = new TmfCheckpoint(this.fTimestamp1, this.fLocation2, this.RANK2);
        TmfCheckpoint checkpoint4 = new TmfCheckpoint(this.fTimestamp1, null, this.RANK1);
        TmfCheckpoint checkpoint5 = new TmfCheckpoint(null, this.fLocation1, this.RANK1);
        Assert.assertFalse((String)"equals", (boolean)checkpoint1.equals(null));
        Assert.assertFalse((String)"equals", (boolean)checkpoint1.equals((Object)TmfTimestamp.fromSeconds((long)0L)));
        Assert.assertFalse((String)"equals", (boolean)checkpoint1.equals((Object)checkpoint4));
        Assert.assertFalse((String)"equals", (boolean)checkpoint1.equals((Object)checkpoint5));
        Assert.assertFalse((String)"equals", (boolean)checkpoint4.equals((Object)checkpoint1));
        Assert.assertFalse((String)"equals", (boolean)checkpoint5.equals((Object)checkpoint1));
        Assert.assertFalse((String)"equals", (boolean)checkpoint1.equals((Object)checkpoint2));
        Assert.assertFalse((String)"equals", (boolean)checkpoint1.equals((Object)checkpoint3));
    }

    @Test
    public void testToString() {
        String expected1 = "TmfCheckpoint [fLocation=" + this.fCheckpoint1.getLocation() + ", fTimestamp=" + this.fCheckpoint1.getTimestamp() + ", fCheckpointRank=" + this.fCheckpoint1.getCheckpointRank() + "]";
        String expected2 = "TmfCheckpoint [fLocation=" + this.fCheckpoint2.getLocation() + ", fTimestamp=" + this.fCheckpoint2.getTimestamp() + ", fCheckpointRank=" + this.fCheckpoint2.getCheckpointRank() + "]";
        String expected3 = "TmfCheckpoint [fLocation=" + this.fCheckpoint3.getLocation() + ", fTimestamp=" + this.fCheckpoint3.getTimestamp() + ", fCheckpointRank=" + this.fCheckpoint3.getCheckpointRank() + "]";
        Assert.assertEquals((String)"toString", (Object)expected1, (Object)this.fCheckpoint1.toString());
        Assert.assertEquals((String)"toString", (Object)expected2, (Object)this.fCheckpoint2.toString());
        Assert.assertEquals((String)"toString", (Object)expected3, (Object)this.fCheckpoint3.toString());
    }
}

