/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.symbols;

import java.util.Collection;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.junit.Assert;
import org.junit.Test;

public class SymbolProviderManagerTest {
    @Test
    public void testGetterForExperiment() {
        ITmfTrace trace = null;
        TmfExperiment experiment = null;
        try {
            trace = TmfTestTrace.A_TEST_10K.getTrace();
            ITmfTrace[] traces = new ITmfTrace[]{trace};
            experiment = new TmfExperiment(ITmfEvent.class, "test-exp", traces, 5000, null);
            Collection traceSymbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
            Assert.assertTrue((!traceSymbolProviders.isEmpty() ? 1 : 0) != 0);
            Collection expSymbolProviders = SymbolProviderManager.getInstance().getSymbolProviders((ITmfTrace)experiment);
            Assert.assertTrue((!expSymbolProviders.isEmpty() ? 1 : 0) != 0);
            for (ISymbolProvider sp : expSymbolProviders) {
                Assert.assertTrue((sp.getTrace() == trace ? 1 : 0) != 0);
            }
            for (ISymbolProvider symbolProvider : traceSymbolProviders) {
                Assert.assertTrue((boolean)expSymbolProviders.contains(symbolProvider));
            }
        }
        finally {
            if (trace != null) {
                trace.dispose();
            }
            if (experiment != null) {
                experiment.dispose();
            }
        }
    }
}

