/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.fsm.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlActionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlFsmStateCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionResetStoredFields;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionSegment;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenActionUpdateStoredFields;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenCondition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmSimpleState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmStateTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueConstant;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventField;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValueEventName;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TmfXmlFsmCuTest {
    private static final @NonNull String STATE1_NAME = "state1";
    private static final @NonNull String STATE2_NAME = "state2";
    private static final @NonNull String STATE_FINAL_NAME = "final";
    private static final @NonNull String ACTION1_NAME = "action1";
    private static final @NonNull String ACTION2_NAME = "action2";
    private static final @NonNull String TEST1_NAME = "test1";
    private static final @NonNull String TEST2_NAME = "test2";
    private static final @NonNull String FSM_START = "<fsm id=\"%s\" %s>";
    private static final @NonNull String FSM_END = "</fsm>";
    private static final @NonNull String STATE_START = "<state id=\"%s\">";
    private static final @NonNull String STATE_END = "</state>";
    private static final @NonNull String TRANSITION_STRING = "<transition %s %s %s %s %s %s/>";
    private static final @NonNull String SAVE_STORED_FIELDS = "saveStoredFields=\"true\"";
    private static final @NonNull String CLEAR_STORED_FIELDS = "clearStoredFields=\"true\"";
    private static final @NonNull String EVENTS_STRING = "event=\"sys*\"";
    private static final @NonNull String ACTION_STRING = "action=\"%s\"";
    private static final @NonNull String TARGET_STRING = "target=\"%s\"";
    private static final @NonNull String TEST_STRING = "cond=\"%s\"";
    private static final @NonNull String WRAPPER_STRING = "<doc>%s</doc>";
    private static final @NonNull String ACTION1 = "<action id=\"action1\"><segment><segType segName=\"test\"/></segment></action>";
    private static final @NonNull String ACTION2 = "<action id=\"action2\"><segment><segType segName=\"hello\"/></segment></action>";
    private static final @NonNull String TEST1 = "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test>";
    private static final @NonNull String TEST2 = "<test id=\"test2\"><if><condition><stateValue type=\"int\" value=\"0\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test>";
    private static final @NonNull DataDrivenAction ACTION1_DD = new DataDrivenActionSegment((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"test"), null, null, null, Collections.emptyMap());
    private static final @NonNull DataDrivenAction ACTION2_DD = new DataDrivenActionSegment((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)"hello"), null, null, null, Collections.emptyMap());
    private static final @NonNull DataDrivenCondition EVENT_CONDITION = new DataDrivenCondition.DataDrivenRegexCondition(Pattern.compile("sys.*"), (DataDrivenValue)new DataDrivenValueEventName(null));
    private static final @NonNull DataDrivenCondition TEST1_DD = new DataDrivenCondition.DataDrivenComparisonCondition((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)2), (DataDrivenValue)new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, "cpu"), DataDrivenCondition.ConditionOperator.EQ);
    private static final @NonNull DataDrivenCondition TEST2_DD = new DataDrivenCondition.DataDrivenComparisonCondition((DataDrivenValue)new DataDrivenValueConstant(null, ITmfStateValue.Type.NULL, (Object)0), (DataDrivenValue)new DataDrivenValueEventField(null, ITmfStateValue.Type.NULL, "cpu"), DataDrivenCondition.ConditionOperator.EQ);
    private static final @NonNull CompilationResult VALID_ONE_STATE_FINAL = new CompilationResult(){

        @Override
        public String getName() {
            return "one_state_final";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"")) + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END;
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.emptyList(), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_ONE_STATE_LOOP = new CompilationResult(){

        @Override
        public String getName() {
            return "one_state_loop";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"") + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME), String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, TEST1_DD, TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(ACTION1_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_SAVE_CLEAR_FIELDS = new CompilationResult(){

        @Override
        public String getName() {
            return "save_and_clear_fields";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"") + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME), String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), TmfXmlFsmCuTest.SAVE_STORED_FIELDS, TmfXmlFsmCuTest.CLEAR_STORED_FIELDS) + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, TEST1_DD, TmfXmlFsmCuTest.STATE1_NAME, (List)ImmutableList.of((Object)ACTION1_DD, (Object)DataDrivenActionUpdateStoredFields.getInstance(), (Object)DataDrivenActionResetStoredFields.getInstance()))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_MULTIPLE_ACTIONS_TESTS = new CompilationResult(){

        @Override
        public String getName() {
            return "multiple_actions_and_tests";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><test id=\"test2\"><if><condition><stateValue type=\"int\" value=\"0\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action><action id=\"action2\"><segment><segType segName=\"hello\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"") + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, "action1:action2"), String.format(TmfXmlFsmCuTest.TEST_STRING, "test1:test2"), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, (DataDrivenCondition)new DataDrivenCondition.DataDrivenAndCondition((List)ImmutableList.of((Object)TEST1_DD, (Object)TEST2_DD)), TmfXmlFsmCuTest.STATE1_NAME, (List)ImmutableList.of((Object)ACTION1_DD, (Object)ACTION2_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_MULTIPLE_STATES_TRANSITIONS = new CompilationResult(){

        @Override
        public String getName() {
            return "multiple_states_and_transitions";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><test id=\"test2\"><if><condition><stateValue type=\"int\" value=\"0\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action><action id=\"action2\"><segment><segType segName=\"hello\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"") + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION2_NAME), String.format(TmfXmlFsmCuTest.TEST_STRING, "test1:test2"), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME), String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE2_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE2_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, "", String.format(TmfXmlFsmCuTest.TEST_STRING, "test1:test2"), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE_FINAL_NAME), "", "") + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME), String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST2_NAME), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + "<final id=\"" + TmfXmlFsmCuTest.STATE_FINAL_NAME + "\"/>" + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, (List)ImmutableList.of((Object)new DataDrivenFsmStateTransition(EVENT_CONDITION, (DataDrivenCondition)new DataDrivenCondition.DataDrivenAndCondition((List)ImmutableList.of((Object)TEST1_DD, (Object)TEST2_DD)), TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(ACTION2_DD)), (Object)new DataDrivenFsmStateTransition(EVENT_CONDITION, TEST1_DD, TmfXmlFsmCuTest.STATE2_NAME, Collections.singletonList(ACTION1_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            DataDrivenFsmSimpleState state2 = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE2_NAME, (List)ImmutableList.of((Object)new DataDrivenFsmStateTransition(EVENT_CONDITION, (DataDrivenCondition)new DataDrivenCondition.DataDrivenAndCondition((List)ImmutableList.of((Object)TEST1_DD, (Object)TEST2_DD)), TmfXmlFsmCuTest.STATE_FINAL_NAME, Collections.emptyList()), (Object)new DataDrivenFsmStateTransition(EVENT_CONDITION, TEST2_DD, TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(ACTION1_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            DataDrivenFsmSimpleState finalState = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE_FINAL_NAME, Collections.emptyList(), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state, (Object)TmfXmlFsmCuTest.STATE2_NAME, (Object)state2, (Object)TmfXmlFsmCuTest.STATE_FINAL_NAME, (Object)finalState), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_ON_ENTRY_EXIT = new CompilationResult(){

        @Override
        public String getName() {
            return "on_entry_exit";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><test id=\"test2\"><if><condition><stateValue type=\"int\" value=\"0\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action><action id=\"action2\"><segment><segType segName=\"hello\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"") + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + "<onentry action=\"" + TmfXmlFsmCuTest.ACTION1_NAME + "\"/>" + "<onexit action=\"" + TmfXmlFsmCuTest.ACTION2_NAME + "\"/>" + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, "", String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE_FINAL_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + "<final id=\"" + TmfXmlFsmCuTest.STATE_FINAL_NAME + "\"/>" + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, TEST1_DD, TmfXmlFsmCuTest.STATE_FINAL_NAME, Collections.emptyList())), ACTION1_DD, ACTION2_DD);
            DataDrivenFsmSimpleState finalState = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE_FINAL_NAME, Collections.emptyList(), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state, (Object)TmfXmlFsmCuTest.STATE_FINAL_NAME, (Object)finalState), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_PRECONDITION = new CompilationResult(){

        @Override
        public String getName() {
            return "with_precondition";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><test id=\"test2\"><if><condition><stateValue type=\"int\" value=\"0\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action><action id=\"action2\"><segment><segType segName=\"hello\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"") + "<" + "precondition" + " " + TmfXmlFsmCuTest.EVENTS_STRING + " " + String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME) + "/>" + "<" + "precondition" + " " + "event" + "=\"test\" " + String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME) + " " + String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME) + "/>" + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, "action1:action2"), String.format(TmfXmlFsmCuTest.TEST_STRING, "test1:test2"), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, (DataDrivenCondition)new DataDrivenCondition.DataDrivenAndCondition((List)ImmutableList.of((Object)TEST1_DD, (Object)TEST2_DD)), TmfXmlFsmCuTest.STATE1_NAME, (List)ImmutableList.of((Object)ACTION1_DD, (Object)ACTION2_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            DataDrivenCondition.DataDrivenOrCondition preCond = new DataDrivenCondition.DataDrivenOrCondition((List)ImmutableList.of((Object)new DataDrivenCondition.DataDrivenAndCondition((List)ImmutableList.of((Object)EVENT_CONDITION, (Object)TEST1_DD)), (Object)new DataDrivenCondition.DataDrivenAndCondition((List)ImmutableList.of((Object)new DataDrivenCondition.DataDrivenRegexCondition(Pattern.compile("test"), (DataDrivenValue)new DataDrivenValueEventName(null)), (Object)TEST1_DD))));
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), (DataDrivenCondition)preCond, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_INITIAL_STATE = new CompilationResult(){

        @Override
        public String getName() {
            return "initial state";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><test id=\"test2\"><if><condition><stateValue type=\"int\" value=\"0\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action><action id=\"action2\"><segment><segType segName=\"hello\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "") + "<initialState>" + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME), String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + "</initialState>" + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, "action1:action2"), String.format(TmfXmlFsmCuTest.TEST_STRING, "test1:test2"), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState initial = new DataDrivenFsmSimpleState("initialState", Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, TEST1_DD, TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(ACTION1_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, (DataDrivenCondition)new DataDrivenCondition.DataDrivenAndCondition((List)ImmutableList.of((Object)TEST1_DD, (Object)TEST2_DD)), TmfXmlFsmCuTest.STATE1_NAME, (List)ImmutableList.of((Object)ACTION1_DD, (Object)ACTION2_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)initial, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_INITIAL = new CompilationResult(){

        @Override
        public String getName() {
            return "initial_element";
        }

        @Override
        public String getXmlString() {
            return String.format(TmfXmlFsmCuTest.WRAPPER_STRING, "<test id=\"test1\"><if><condition><stateValue type=\"int\" value=\"2\"/><stateValue type=\"eventField\" value=\"cpu\" /></condition></if></test><action id=\"action1\"><segment><segType segName=\"test\"/></segment></action>" + String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "") + "<initial>" + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, "", "", "", String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + "</initial>" + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME), String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END);
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(new DataDrivenFsmStateTransition(EVENT_CONDITION, TEST1_DD, TmfXmlFsmCuTest.STATE1_NAME, Collections.singletonList(ACTION1_DD))), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult VALID_NO_INITIAL = new CompilationResult(){

        @Override
        public String getName() {
            return "valid_no_initial";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "")) + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END;
        }

        @Override
        public DataDrivenFsm getResult() {
            DataDrivenFsmSimpleState state = new DataDrivenFsmSimpleState(TmfXmlFsmCuTest.STATE1_NAME, Collections.emptyList(), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
            return new DataDrivenFsm(this.getName(), (DataDrivenFsmState)state, (Map)ImmutableMap.of((Object)TmfXmlFsmCuTest.STATE1_NAME, (Object)state), DataDrivenCondition.TRUE_CONDITION, true, true);
        }
    };
    private static final @NonNull CompilationResult INVALID_UNDEFINED_ACTION = new CompilationResult(){

        @Override
        public String getName() {
            return "undefined_action";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"")) + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.ACTION_STRING, TmfXmlFsmCuTest.ACTION1_NAME), "", String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END;
        }

        @Override
        public DataDrivenFsm getResult() {
            return null;
        }
    };
    private static final @NonNull CompilationResult INVALID_UNDEFINED_CONDITION = new CompilationResult(){

        @Override
        public String getName() {
            return "undefined_condition";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"")) + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), "", String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE1_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END;
        }

        @Override
        public DataDrivenFsm getResult() {
            return null;
        }
    };
    private static final @NonNull CompilationResult INVALID_UNDEFINED_TARGET = new CompilationResult(){

        @Override
        public String getName() {
            return "undefined_target";
        }

        @Override
        public String getXmlString() {
            return String.valueOf(String.format(TmfXmlFsmCuTest.FSM_START, this.getName(), "initial=\"state1\"")) + String.format(TmfXmlFsmCuTest.STATE_START, TmfXmlFsmCuTest.STATE1_NAME) + String.format(TmfXmlFsmCuTest.TRANSITION_STRING, TmfXmlFsmCuTest.EVENTS_STRING, String.format(TmfXmlFsmCuTest.TEST_STRING, TmfXmlFsmCuTest.TEST1_NAME), "", String.format(TmfXmlFsmCuTest.TARGET_STRING, TmfXmlFsmCuTest.STATE2_NAME), "", "") + TmfXmlFsmCuTest.STATE_END + TmfXmlFsmCuTest.FSM_END;
        }

        @Override
        public DataDrivenFsm getResult() {
            return null;
        }
    };
    private final CompilationResult fExpected;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({VALID_ONE_STATE_FINAL}, {VALID_ONE_STATE_LOOP}, {VALID_SAVE_CLEAR_FIELDS}, {VALID_MULTIPLE_ACTIONS_TESTS}, {VALID_MULTIPLE_STATES_TRANSITIONS}, {VALID_ON_ENTRY_EXIT}, {VALID_PRECONDITION}, {VALID_INITIAL_STATE}, {VALID_INITIAL}, {INVALID_UNDEFINED_ACTION}, {INVALID_UNDEFINED_CONDITION}, {INVALID_UNDEFINED_TARGET}, {VALID_NO_INITIAL});
    }

    public TmfXmlFsmCuTest(CompilationResult expected) {
        this.fExpected = expected;
    }

    @Test
    public void testFsm() throws SAXException, IOException, ParserConfigurationException {
        AnalysisCompilationData data = new AnalysisCompilationData();
        TmfXmlFsmCuTest.compileActionsAndTests(this.fExpected.getXmlString(), data);
        Element xmlElement = TmfXmlTestUtils.getXmlElement("fsm", this.fExpected.getXmlString());
        Assert.assertNotNull((Object)xmlElement);
        TmfXmlFsmStateCu.TmfXmlFsmCu compiledFsm = TmfXmlFsmStateCu.compileFsm((AnalysisCompilationData)data, (Element)xmlElement);
        if (this.fExpected.getResult() == null) {
            Assert.assertNull((String)("Expected null action" + this.fExpected.getName()), (Object)compiledFsm);
        } else {
            Assert.assertNotNull((String)("Expected non null " + this.fExpected.getName()), (Object)compiledFsm);
            Assert.assertEquals((String)(String.valueOf(this.fExpected.getName()) + " generated"), (Object)this.fExpected.getResult(), (Object)compiledFsm.generate());
        }
    }

    private static void compileActionsAndTests(@NonNull String xmlString, @NonNull AnalysisCompilationData data) throws SAXException, IOException, ParserConfigurationException {
        List<@NonNull Element> xmlElements = TmfXmlTestUtils.getXmlElements("action", xmlString);
        for (Element xmlElement : xmlElements) {
            Assert.assertNotNull((Object)TmfXmlActionCu.compileNamedAction((AnalysisCompilationData)data, (Element)xmlElement));
        }
        xmlElements = TmfXmlTestUtils.getXmlElements("test", xmlString);
        for (Element xmlElement : xmlElements) {
            Assert.assertNotNull((Object)TmfXmlConditionCu.compileNamedCondition((AnalysisCompilationData)data, (Element)xmlElement));
        }
    }

    private static abstract class CompilationResult {
        private CompilationResult() {
        }

        public abstract @NonNull String getName();

        public abstract @NonNull String getXmlString();

        public abstract @Nullable DataDrivenFsm getResult();

        public String toString() {
            return this.getName();
        }
    }
}

