/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.event.matching;

import java.io.File;
import java.util.function.Supplier;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Test;

public class LttngExperimentAnalysisBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools# Experiment Analysis benchmarking#";
    private static final String CPU = " (cpu usage)";
    private static final String TEST_SUMMARY = "Trace Compass Scalability- Experiment benchmark";

    private static void testExperiment(String directoryPath, int loopCount, Supplier<IAnalysisModule> moduleSupplier, boolean isExperiment) throws TmfTraceException, TmfAnalysisException {
        File parentDirectory = new File(directoryPath);
        if (!parentDirectory.isDirectory() || parentDirectory.list() == null) {
            System.err.println(String.format("Trace directory not found !\nYou need to setup the directory path for the LttngExperimentAnalysisBenchmar class. See the javadoc of this class.", new Object[0]));
            return;
        }
        File[] filesList = parentDirectory.listFiles();
        int size = filesList.length;
        String testName = "Experiment of" + Integer.toString(size);
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName + CPU);
        perf.tagAsSummary(pm, "Trace Compass Scalability- Experiment benchmark:" + testName + CPU, Dimension.CPU_TIME);
        int j = 0;
        while (j < loopCount) {
            CtfTmfTrace[] traces = new CtfTmfTrace[size];
            IAnalysisModule[] modules = new IAnalysisModule[size];
            int i = 0;
            File[] fileArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String path = String.valueOf(file.getAbsolutePath()) + "/kernel";
                CtfTmfTrace trace = new CtfTmfTrace();
                trace.initTrace(null, path, CtfTmfEvent.class);
                traces[i] = trace;
                if (!isExperiment) {
                    IAnalysisModule module = null;
                    module = moduleSupplier.get();
                    module.setId("test");
                    module.setTrace((ITmfTrace)trace);
                    modules[i] = module;
                }
                ++i;
                ++n2;
            }
            TmfExperiment experiment = new TmfExperiment(CtfTmfEvent.class, "Test experiment", (ITmfTrace[])traces, 5000, null);
            IAnalysisModule module = null;
            if (isExperiment) {
                module = moduleSupplier.get();
                module.setId("test");
                module.setTrace((ITmfTrace)experiment);
                pm.start();
                module.schedule();
                module.waitForCompletion();
                pm.stop();
                module.dispose();
            } else {
                pm.start();
                IAnalysisModule[] iAnalysisModuleArray = modules;
                int n3 = modules.length;
                int n4 = 0;
                while (n4 < n3) {
                    IAnalysisModule mod = iAnalysisModuleArray[n4];
                    mod.schedule();
                    ++n4;
                }
                iAnalysisModuleArray = modules;
                n3 = modules.length;
                n4 = 0;
                while (n4 < n3) {
                    IAnalysisModule mod = iAnalysisModuleArray[n4];
                    mod.waitForCompletion();
                    ++n4;
                }
                pm.stop();
                iAnalysisModuleArray = modules;
                n3 = modules.length;
                n4 = 0;
                while (n4 < n3) {
                    IAnalysisModule mod = iAnalysisModuleArray[n4];
                    mod.dispose();
                    ++n4;
                }
            }
            experiment.dispose();
            ++j;
        }
        pm.commit();
    }

    @Test
    public void runTest() throws TmfTraceException, TmfAnalysisException {
        Supplier<IAnalysisModule> moduleSupplier = () -> new KernelAnalysisModule();
        String directoryPath = "null";
        int loopCount = 5;
        boolean isExperiment = false;
        LttngExperimentAnalysisBenchmark.testExperiment(directoryPath, loopCount, moduleSupplier, isExperiment);
    }
}

