/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegerEndiannessTest {
    private static final @NonNull String name = "testInt";
    private static final @NonNull String clockName = "clock";
    private ByteBuffer bb;
    private @NonNull BitBuffer input = new BitBuffer();

    @Before
    public void setUp() {
        ByteBuffer byb = this.bb = ByteBuffer.allocateDirect(8);
        this.bb.put((byte)-85);
        this.bb.put((byte)-51);
        this.bb.put((byte)-17);
        this.bb.put((byte)18);
        this.bb.put((byte)52);
        this.bb.put((byte)86);
        this.bb.put((byte)120);
        this.bb.put((byte)-102);
        this.input = new BitBuffer(byb);
    }

    @Test
    public void test32BE() throws CTFException {
        IntegerDeclaration be = IntegerDeclaration.createDeclaration((int)32, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)clockName, (long)8L);
        IntegerDefinition fixture_be = be.createDefinition(null, name, this.input);
        Assert.assertEquals((long)-1412567278L, (long)fixture_be.getValue());
    }

    @Test
    public void test64BE() throws CTFException {
        IntegerDeclaration be = IntegerDeclaration.createDeclaration((int)64, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)clockName, (long)8L);
        IntegerDefinition fixture_be = be.createDefinition(null, name, this.input);
        Assert.assertEquals((long)-6066930261531658086L, (long)fixture_be.getValue());
    }

    @Test
    public void test32LE() throws CTFException {
        IntegerDeclaration le = IntegerDeclaration.createDeclaration((int)32, (boolean)true, (int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.NONE, (String)clockName, (long)8L);
        IntegerDefinition fixture_le = le.createDefinition(null, name, this.input);
        Assert.assertEquals((long)317705643L, (long)fixture_le.getValue());
    }

    @Test
    public void test64LE() throws CTFException {
        IntegerDeclaration le = IntegerDeclaration.createDeclaration((int)64, (boolean)true, (int)1, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.NONE, (String)clockName, (long)8L);
        IntegerDefinition fixture_le = le.createDefinition(null, name, this.input);
        Assert.assertEquals((long)-7316002813007376981L, (long)fixture_le.getValue());
    }
}

