/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;

class PacketStub
implements ICTFPacketDescriptor {
    private final long fOffsetBytes;
    private final long fTsStart;
    private final long fTsEnd;

    public PacketStub(long packetNumber, long start, long end) {
        this.fOffsetBytes = packetNumber * this.getPacketSizeBits();
        this.fTsStart = start;
        this.fTsEnd = end;
    }

    public boolean includes(long ts) {
        return ts >= this.fTsStart && ts <= this.fTsEnd;
    }

    public long getOffsetBits() {
        return this.fOffsetBytes * 8L;
    }

    public long getPacketSizeBits() {
        return 3L;
    }

    public long getContentSizeBits() {
        return 2L;
    }

    public long getTimestampBegin() {
        return this.fTsStart;
    }

    public long getTimestampEnd() {
        return this.fTsEnd;
    }

    public long getLostEvents() {
        return 0L;
    }

    public @NonNull Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public String getTarget() {
        return "";
    }

    public long getTargetId() {
        return 0L;
    }

    public long getOffsetBytes() {
        return this.fOffsetBytes;
    }

    public long getPayloadStartBits() {
        return 1L;
    }

    public String toString() {
        return "[" + this.fOffsetBytes + ", " + this.fTsStart + " - " + this.fTsEnd + "]";
    }
}

