/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.DownloadTraceHttpHelper;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceDownloadStatus;
import org.eclipse.tracecompass.tmf.ui.tests.TmfUITestPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class DownloadTraceHttpHelperTest {
    private static String fTestTrace1Url = "http://archive.eclipse.org/tracecompass/test-traces/tmf/syslog";
    private static String fTestTrace2Url = "http://archive.eclipse.org/tracecompass/test-traces/tmf/syslog_collapse";
    private static String fTraceArchiveUrl = "http://archive.eclipse.org/tracecompass/test-traces/tmf/syslogs.zip";
    private static String fDestinationDirectory;

    @BeforeClass
    public static void beforeClass() throws Exception {
        fDestinationDirectory = TmfUITestPlugin.getDefault().getStateLocation().append("httpDownloadTestDirectory").toOSString();
    }

    @After
    public void afterTest() throws IOException {
        File destFile = new File(fDestinationDirectory);
        FileUtils.deleteDirectory((File)destFile);
    }

    @Test
    public void testTraceDownload() {
        TraceDownloadStatus status = DownloadTraceHttpHelper.downloadTrace((String)fTestTrace1Url, (String)fDestinationDirectory);
        Assume.assumeFalse((boolean)status.isTimeout());
        Assert.assertTrue((boolean)status.isOk());
        DownloadTraceHttpHelperTest.validateSingleDownload(status.getDownloadedFile(), "syslog");
    }

    @Test
    public void testMutlipleTracesDownload() {
        ArrayList<String> tracesUrl = new ArrayList<String>();
        tracesUrl.add(fTestTrace1Url);
        tracesUrl.add(fTestTrace2Url);
        TraceDownloadStatus multipleStatus = DownloadTraceHttpHelper.downloadTraces(tracesUrl, (String)fDestinationDirectory);
        Assume.assumeFalse((boolean)multipleStatus.isTimeout());
        Assert.assertTrue((boolean)multipleStatus.isOk());
        ArrayList<File> downloadedTraces = new ArrayList<File>();
        for (TraceDownloadStatus status : multipleStatus.getChildren()) {
            downloadedTraces.add(status.getDownloadedFile());
        }
        Assert.assertEquals((long)2L, (long)downloadedTraces.size());
        DownloadTraceHttpHelperTest.validateMultipleDownload(downloadedTraces);
    }

    @Test
    public void testArchiveTraceDownload() {
        TraceDownloadStatus status = DownloadTraceHttpHelper.downloadTrace((String)fTraceArchiveUrl, (String)fDestinationDirectory);
        Assume.assumeFalse((boolean)status.isTimeout());
        Assert.assertTrue((boolean)status.isOk());
        DownloadTraceHttpHelperTest.validateSingleDownload(status.getDownloadedFile(), "syslogs.zip");
    }

    private static void validateSingleDownload(File downloadedFile, String expectedFileName) {
        Assert.assertEquals((Object)expectedFileName, (Object)downloadedFile.getName());
        File dest = new File(fDestinationDirectory);
        File[] listFiles = dest.listFiles();
        Assert.assertEquals((long)1L, (long)listFiles.length);
        Assert.assertEquals((Object)expectedFileName, (Object)listFiles[0].getName());
        Assert.assertTrue((boolean)listFiles[0].exists());
    }

    private static void validateMultipleDownload(List<File> downloadedFile) {
        File dest = new File(fDestinationDirectory);
        File[] listFiles = dest.listFiles();
        Assert.assertEquals((long)2L, (long)listFiles.length);
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Assert.assertTrue((boolean)file.exists());
            ++n2;
        }
    }
}

