/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.model;

import java.util.Comparator;
import java.util.stream.StreamSupport;
import org.eclipse.swtchart.model.SeriesModel;

public interface CartesianSeriesModel<T>
extends SeriesModel<T> {
    public static final Integer ZERO = 0;
    public static final Comparator<Number> DEFAULT_NUMBER_COMPARATOR = new Comparator<Number>(){

        @Override
        public int compare(Number o1, Number o2) {
            return Double.compare(o1.doubleValue(), o2.doubleValue());
        }
    };

    public Number getX(T var1);

    public Number getY(T var1);

    default public Number getMinX() {
        return StreamSupport.stream(this.spliterator(), false).filter(v -> this.getX(v) != null).map(v -> this.getX(v)).min(DEFAULT_NUMBER_COMPARATOR).get();
    }

    default public Number getMinY() {
        return StreamSupport.stream(this.spliterator(), false).filter(v -> this.getY(v) != null).map(v -> this.getY(v)).min(DEFAULT_NUMBER_COMPARATOR).get();
    }

    default public Number getMinZ() {
        return StreamSupport.stream(this.spliterator(), false).filter(v -> this.getZ(v) != null).map(v -> this.getZ(v)).min(DEFAULT_NUMBER_COMPARATOR).get();
    }

    default public Number getMaxX() {
        return StreamSupport.stream(this.spliterator(), false).filter(v -> this.getX(v) != null).map(v -> this.getX(v)).max(DEFAULT_NUMBER_COMPARATOR).get();
    }

    default public Number getMaxY() {
        return StreamSupport.stream(this.spliterator(), false).filter(v -> this.getY(v) != null).map(v -> this.getY(v)).max(DEFAULT_NUMBER_COMPARATOR).get();
    }

    default public Number getMaxZ() {
        return StreamSupport.stream(this.spliterator(), false).filter(v -> this.getZ(v) != null).map(v -> this.getZ(v)).max(DEFAULT_NUMBER_COMPARATOR).get();
    }

    default public Number getZ(T data) {
        if (this.getX(data) != null) {
            return ZERO;
        }
        return null;
    }
}

