/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.css2;

import org.w3c.dom.css.CSSPrimitiveValue;

public class CSS2FontHelper {
    public static String getFontFamily(String family) {
        if (family == null) {
            return null;
        }
        if (family.indexOf(32) != -1 || family.startsWith("@")) {
            family = "\"" + family + "\"";
        }
        return family;
    }

    public static String getFontSize(int size) {
        return Integer.toString(size);
    }

    public static String getFontStyle(boolean isItalic) {
        if (isItalic) {
            return "italic";
        }
        return "normal";
    }

    public static String getFontWeight(boolean isBold) {
        if (isBold) {
            return "bold";
        }
        return "normal";
    }

    public static String getCSSFontPropertyName(CSSPrimitiveValue value) {
        short type = value.getPrimitiveType();
        switch (type) {
            case 19: 
            case 21: {
                switch (value.getStringValue()) {
                    case "oblique": 
                    case "italic": {
                        return "font-style";
                    }
                    case "bolder": 
                    case "normal": 
                    case "bold": {
                        return "font-weight";
                    }
                }
                return "font-family";
            }
            case 1: 
            case 5: 
            case 9: {
                return "font-size";
            }
        }
        return null;
    }
}

