/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.model;

import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableColumnDescriptorTest {
    private static final String TO_STRING = "toString";
    private static final String HASH_CODE = "hashCode";
    private static final String EQUALS = "equals";
    private static final String COLUMN_TEXT0 = "Name";
    private static final String COLUMN_TOOLTIP0 = "Tooltip";
    private ITableColumnDescriptor fModel0;
    private ITableColumnDescriptor fModel1;

    @Before
    public void setup() {
        this.fModel0 = TableColumnDescriptorTest.createDescriptor(0);
        this.fModel1 = TableColumnDescriptorTest.createDescriptor(1);
    }

    @Test
    public void test() {
        TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
        TableColumnDescriptor desc = builder.setText(COLUMN_TEXT0).build();
        Assert.assertEquals((String)"Column header", (Object)COLUMN_TEXT0, (Object)desc.getText());
        Assert.assertTrue((String)"Empty tooltip", (boolean)desc.getTooltip().isEmpty());
        builder = new TableColumnDescriptor.Builder();
        desc = builder.setText(COLUMN_TEXT0).setTooltip(COLUMN_TOOLTIP0).build();
        Assert.assertEquals((String)"Column header", (Object)COLUMN_TEXT0, (Object)desc.getText());
        Assert.assertEquals((String)"Column tooltip", (Object)COLUMN_TOOLTIP0, (Object)desc.getTooltip());
        builder = new TableColumnDescriptor.Builder();
        desc = builder.setTooltip(COLUMN_TOOLTIP0).build();
        Assert.assertTrue((String)"Empty Text", (boolean)desc.getText().isEmpty());
        Assert.assertEquals((String)"Column tooltip", (Object)COLUMN_TOOLTIP0, (Object)desc.getTooltip());
    }

    @Test
    public void testToString() {
        TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
        TableColumnDescriptor desc = builder.setText(COLUMN_TEXT0).setTooltip(COLUMN_TOOLTIP0).build();
        Assert.assertEquals((String)TO_STRING, (Object)"[text=Name tooltip=Tooltip]", (Object)desc.toString());
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertEquals((String)EQUALS, (Object)this.fModel0, (Object)this.fModel0);
        Assert.assertEquals((String)EQUALS, (Object)this.fModel1, (Object)this.fModel1);
        Assert.assertNotEquals((String)EQUALS, (Object)this.fModel0, (Object)this.fModel1);
        Assert.assertNotEquals((String)EQUALS, (Object)this.fModel1, (Object)this.fModel0);
    }

    @Test
    public void testEqualsSymmetry() {
        TableColumnDescriptor model0 = TableColumnDescriptorTest.createDescriptor(0);
        TableColumnDescriptor model1 = TableColumnDescriptorTest.createDescriptor(1);
        Assert.assertEquals((String)EQUALS, (Object)model0, (Object)this.fModel0);
        Assert.assertEquals((String)EQUALS, (Object)this.fModel0, (Object)model0);
        Assert.assertEquals((String)EQUALS, (Object)model1, (Object)this.fModel1);
        Assert.assertEquals((String)EQUALS, (Object)this.fModel1, (Object)model1);
    }

    @Test
    public void testEqualsTransivity() {
        TableColumnDescriptor model0 = TableColumnDescriptorTest.createDescriptor(0);
        TableColumnDescriptor model1 = TableColumnDescriptorTest.createDescriptor(0);
        TableColumnDescriptor model2 = TableColumnDescriptorTest.createDescriptor(0);
        Assert.assertEquals((String)EQUALS, (Object)model0, (Object)model1);
        Assert.assertEquals((String)EQUALS, (Object)model1, (Object)model2);
        Assert.assertEquals((String)EQUALS, (Object)model0, (Object)model2);
    }

    @Test
    public void testEqualsNull() {
        Object model0 = null;
        Assert.assertNotEquals((String)EQUALS, (Object)this.fModel0, model0);
        Assert.assertNotEquals((String)EQUALS, (Object)this.fModel1, model0);
    }

    @Test
    public void testHashCode() {
        TableColumnDescriptor model0 = TableColumnDescriptorTest.createDescriptor(0);
        TableColumnDescriptor model1 = TableColumnDescriptorTest.createDescriptor(1);
        Assert.assertEquals((String)HASH_CODE, (long)this.fModel0.hashCode(), (long)model0.hashCode());
        Assert.assertEquals((String)HASH_CODE, (long)this.fModel1.hashCode(), (long)model1.hashCode());
        Assert.assertNotEquals((String)HASH_CODE, (long)this.fModel0.hashCode(), (long)model1.hashCode());
        Assert.assertNotEquals((String)HASH_CODE, (long)this.fModel1.hashCode(), (long)model0.hashCode());
    }

    private static TableColumnDescriptor createDescriptor(int i) {
        TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
        return builder.setText(COLUMN_TEXT0 + String.valueOf(i)).setTooltip(COLUMN_TOOLTIP0 + String.valueOf(i)).build();
    }
}

