/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegerDefinitionTest {
    private IntegerDefinition fixture;
    private static final @NonNull String NAME = "testInt";
    private static final @NonNull String clockName = "clock";

    @Before
    public void setUp() throws CTFException {
        IntegerDeclaration id = IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)clockName, (long)8L);
        ByteBuffer byb = ByteBuffer.allocate(128);
        byb.mark();
        byb.putInt(1);
        byb.reset();
        BitBuffer bb = new BitBuffer(byb);
        this.fixture = id.createDefinition(null, NAME, bb);
    }

    @Test
    public void testIntegerDefinition() {
        IntegerDeclaration declaration = IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L);
        IDefinitionScope definitionScope = null;
        String fieldName = "";
        IntegerDefinition result = new IntegerDefinition(declaration, definitionScope, fieldName, 1L);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDeclaration() {
        IntegerDeclaration result = this.fixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetValue() {
        long result = this.fixture.getValue();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        Assert.assertEquals((Object)"0", (Object)result);
    }

    @Test
    public void testFormatNumber_unsignedLong() {
        long unsignedLongValue = -64L;
        String result = IntegerDefinition.formatNumber((long)unsignedLongValue, (int)10, (boolean)false);
        Assert.assertEquals((Object)"18446744073709551552", (Object)result);
        unsignedLongValue = -131940199973272L;
        result = IntegerDefinition.formatNumber((long)unsignedLongValue, (int)10, (boolean)false);
        Assert.assertEquals((Object)"18446612133509578344", (Object)result);
        unsignedLongValue = 123456789L;
        result = IntegerDefinition.formatNumber((long)unsignedLongValue, (int)10, (boolean)false);
        Assert.assertEquals((Object)"123456789", (Object)result);
    }

    @Test
    public void testFormatNumber_signedLong() {
        long signedValue = -64L;
        String result = IntegerDefinition.formatNumber((long)signedValue, (int)10, (boolean)true);
        Assert.assertEquals((Object)"-64", (Object)result);
        signedValue = -131940199973272L;
        result = IntegerDefinition.formatNumber((long)signedValue, (int)10, (boolean)true);
        Assert.assertEquals((Object)"-131940199973272", (Object)result);
        signedValue = 123456789L;
        result = IntegerDefinition.formatNumber((long)signedValue, (int)10, (boolean)true);
        Assert.assertEquals((Object)"123456789", (Object)result);
    }
}

