/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.math.BigInteger;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegerDeclarationTest {
    private IntegerDeclaration fixture;

    @Before
    public void setUp() {
        this.fixture = IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
    }

    @Test
    public void testIntegerDeclaration() {
        int len = 1;
        boolean signed = false;
        int base = 1;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        Encoding encoding = Encoding.ASCII;
        IntegerDeclaration result = IntegerDeclaration.createDeclaration((int)len, (boolean)signed, (int)base, (ByteOrder)byteOrder, (Encoding)encoding, (String)"", (long)16L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getBase());
        Assert.assertEquals((Object)false, (Object)result.isCharacter());
        String outputValue = "[declaration] integer[";
        Assert.assertEquals((Object)outputValue, (Object)result.toString().substring(0, outputValue.length()));
        Assert.assertEquals((long)1L, (long)result.getLength());
        Assert.assertEquals((Object)false, (Object)result.isSigned());
    }

    @Test
    public void testIntegerDeclarationBruteForce() {
        ByteOrder[] bos = new ByteOrder[]{ByteOrder.LITTLE_ENDIAN, ByteOrder.BIG_ENDIAN};
        Encoding[] encodings = new Encoding[]{Encoding.ASCII, Encoding.NONE, Encoding.UTF8};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] signeds = blArray;
        String[] clocks = new String[]{"something", ""};
        int[] bases = new int[]{2, 4, 6, 8, 10, 12, 16};
        int len = 2;
        while (len < 65) {
            ByteOrder[] byteOrderArray = bos;
            int n = bos.length;
            int n2 = 0;
            while (n2 < n) {
                ByteOrder bo = byteOrderArray[n2];
                boolean[] blArray2 = signeds;
                int n3 = signeds.length;
                int n4 = 0;
                while (n4 < n3) {
                    boolean signed = blArray2[n4];
                    int[] nArray = bases;
                    int n5 = bases.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        int base = nArray[n6];
                        Encoding[] encodingArray = encodings;
                        int n7 = encodings.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            Encoding enc = encodingArray[n8];
                            String[] stringArray = clocks;
                            int n9 = clocks.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                String clock = stringArray[n10];
                                Assert.assertNotNull((Object)enc);
                                Assert.assertNotNull((Object)clock);
                                IntegerDeclaration intDec = IntegerDeclaration.createDeclaration((int)len, (boolean)signed, (int)base, (ByteOrder)bo, (Encoding)enc, (String)clock, (long)8L);
                                String title = String.valueOf(Integer.toString(len)) + " " + bo + " " + signed + " " + base + " " + enc;
                                Assert.assertEquals((String)title, (Object)signed, (Object)intDec.isSigned());
                                Assert.assertEquals((String)title, (long)base, (long)intDec.getBase());
                                if (len != 8) {
                                    Assert.assertEquals((String)title, (Object)bo, (Object)intDec.getByteOrder());
                                }
                                Assert.assertEquals((String)title, (long)len, (long)intDec.getLength());
                                Assert.assertEquals((String)title, (long)len, (long)intDec.getMaximumSize());
                                Assert.assertEquals((String)title, (Object)clock, (Object)intDec.getClock());
                                Assert.assertEquals((String)title, (Object)(!signed && len == 8 ? 1 : 0), (Object)intDec.isUnsignedByte());
                                ++n10;
                            }
                            ++n8;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            ++len;
        }
    }

    @Test
    public void testGetBase() {
        int result = this.fixture.getBase();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testGetByteOrder() {
        ByteOrder result = this.fixture.getByteOrder();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BIG_ENDIAN", (Object)result.toString());
    }

    @Test
    public void testGetEncoding() {
        Encoding result = this.fixture.getEncoding();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"ASCII", (Object)result.name());
        Assert.assertEquals((Object)"ASCII", (Object)result.toString());
        Assert.assertEquals((long)1L, (long)result.ordinal());
    }

    @Test
    public void testGetLength() {
        int result = this.fixture.getLength();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testIsCharacter() {
        boolean result = this.fixture.isCharacter();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testIsCharacter_8bytes() {
        IntegerDeclaration fixture8 = IntegerDeclaration.createDeclaration((int)8, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L);
        boolean result = fixture8.isCharacter();
        Assert.assertEquals((Object)true, (Object)result);
    }

    @Test
    public void testIsSigned_signed() {
        IntegerDeclaration fixtureSigned = IntegerDeclaration.createDeclaration((int)2, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L);
        boolean result = fixtureSigned.isSigned();
        Assert.assertEquals((Object)true, (Object)result);
    }

    @Test
    public void testIsSigned_unsigned() {
        boolean result = this.fixture.isSigned();
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        String trunc = result.substring(0, 22);
        Assert.assertEquals((Object)"[declaration] integer[", (Object)trunc);
    }

    @Test
    public void testMaxValue() {
        Assert.assertEquals((Object)BigInteger.ONE, (Object)this.fixture.getMaxValue());
        IntegerDeclaration signed8bit = IntegerDeclaration.createDeclaration((int)8, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(127L), (Object)signed8bit.getMaxValue());
        IntegerDeclaration unsigned8bit = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(255L), (Object)unsigned8bit.getMaxValue());
        IntegerDeclaration signed32bit = IntegerDeclaration.createDeclaration((int)32, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(Integer.MAX_VALUE), (Object)signed32bit.getMaxValue());
        IntegerDeclaration unsigned32bit = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(0xFFFFFFFFL), (Object)unsigned32bit.getMaxValue());
        IntegerDeclaration signed64bit = IntegerDeclaration.createDeclaration((int)64, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE), (Object)signed64bit.getMaxValue());
        IntegerDeclaration unsigned64bit = IntegerDeclaration.createDeclaration((int)64, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE), (Object)unsigned64bit.getMaxValue());
    }

    @Test
    public void testMinValue() {
        Assert.assertEquals((Object)BigInteger.ZERO, (Object)this.fixture.getMinValue());
        IntegerDeclaration signed8bit = IntegerDeclaration.createDeclaration((int)8, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(-128L), (Object)signed8bit.getMinValue());
        IntegerDeclaration unsigned8bit = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.ZERO, (Object)unsigned8bit.getMinValue());
        IntegerDeclaration signed32bit = IntegerDeclaration.createDeclaration((int)32, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(Integer.MIN_VALUE), (Object)signed32bit.getMinValue());
        IntegerDeclaration unsigned32bit = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.ZERO, (Object)unsigned32bit.getMinValue());
        IntegerDeclaration signed64bit = IntegerDeclaration.createDeclaration((int)64, (boolean)true, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.valueOf(Long.MIN_VALUE), (Object)signed64bit.getMinValue());
        IntegerDeclaration unsigned64bit = IntegerDeclaration.createDeclaration((int)64, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)32L);
        Assert.assertEquals((Object)BigInteger.ZERO, (Object)unsigned64bit.getMinValue());
    }

    @Test
    public void hashcodeTest() {
        IntegerDeclaration a = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        IntegerDeclaration i = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        Assert.assertEquals((long)a.hashCode(), (long)i.hashCode());
        Assert.assertEquals((long)a.hashCode(), (long)a.hashCode());
    }

    @Test
    public void equalsTest() {
        IntegerDeclaration a = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        IntegerDeclaration b = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        IntegerDeclaration c = IntegerDeclaration.createDeclaration((int)32, (boolean)true, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        IntegerDeclaration d = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)16, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        IntegerDeclaration e = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        IntegerDeclaration f = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.UTF8, (String)"", (long)32L);
        IntegerDeclaration g = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"hi", (long)32L);
        IntegerDeclaration h = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)16L);
        IntegerDeclaration i = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)10, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)32L);
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertNotEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)a, (Object)e);
        Assert.assertNotEquals((Object)a, (Object)f);
        Assert.assertNotEquals((Object)a, (Object)g);
        Assert.assertNotEquals((Object)a, (Object)h);
        Assert.assertEquals((Object)a, (Object)i);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertNotEquals((Object)d, (Object)a);
        Assert.assertNotEquals((Object)e, (Object)a);
        Assert.assertNotEquals((Object)f, (Object)a);
        Assert.assertNotEquals((Object)g, (Object)a);
        Assert.assertNotEquals((Object)h, (Object)a);
        Assert.assertEquals((Object)i, (Object)a);
        Assert.assertEquals((Object)a, (Object)a);
    }
}

