/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.model;

import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.Deserializer;
import org.eclipse.wst.validation.internal.Serializer;
import org.eclipse.wst.validation.internal.ValMessages;
import org.eclipse.wst.validation.internal.model.FilterRule;

public abstract class FilterGroup
implements IAdaptable {
    private final FilterRule[] _rules;
    private static final int SerializationVersion = 1;

    public static FilterGroup create(String name, FilterRule[] rules) {
        if ("include".equals(name)) {
            return new FilterIncludeGroup(rules);
        }
        if ("exclude".equals(name)) {
            return new FilterExcludeGroup(rules);
        }
        return null;
    }

    public static FilterGroup create(Deserializer des) {
        des.getInt();
        String type = des.getString();
        int numberRules = des.getInt();
        LinkedList<FilterRule> list = new LinkedList<FilterRule>();
        int i = 0;
        while (i < numberRules) {
            list.add(FilterRule.create(des));
            ++i;
        }
        FilterRule[] rules = new FilterRule[list.size()];
        list.toArray(rules);
        return FilterGroup.create(type, rules);
    }

    public static FilterGroup create(boolean exclude, FilterRule[] rules) {
        if (exclude) {
            return new FilterExcludeGroup(rules);
        }
        return new FilterIncludeGroup(rules);
    }

    public static boolean isKnownName(String name) {
        if ("include".equals(name)) {
            return true;
        }
        return "exclude".equals(name);
    }

    private FilterGroup(FilterRule[] rules) {
        this._rules = rules;
    }

    public final FilterRule[] getRules() {
        FilterRule[] rules = new FilterRule[this._rules.length];
        System.arraycopy(this._rules, 0, rules, 0, this._rules.length);
        return rules;
    }

    public abstract String getType();

    public abstract String getDisplayableType();

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void save(Serializer ser) {
        ser.put(1);
        ser.put(this.getType());
        ser.put(this._rules.length);
        FilterRule[] filterRuleArray = this._rules;
        int n = this._rules.length;
        int n2 = 0;
        while (n2 < n) {
            FilterRule rule = filterRuleArray[n2];
            rule.save(ser);
            ++n2;
        }
    }

    public boolean shouldValidate(IProject project, IResource resource, ContentTypeWrapper contentTypeWrapper) {
        boolean exclude = this.isExclude();
        boolean include = this.isInclude();
        int count = 0;
        FilterRule[] filterRuleArray = this._rules;
        int n = this._rules.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean match;
            FilterRule rule = filterRuleArray[n2];
            if (resource != null) {
                match = rule.matchesResource(resource, contentTypeWrapper);
                if (match != null) {
                    ++count;
                }
                if (exclude && match != null && match.booleanValue()) {
                    return false;
                }
                if (include && match != null && match.booleanValue()) {
                    return true;
                }
            }
            if ((match = rule.matchesProject(project)) != null) {
                ++count;
            }
            if (exclude && match != null && match.booleanValue()) {
                return false;
            }
            if (include && match != null && match.booleanValue()) {
                return true;
            }
            ++n2;
        }
        if (exclude) {
            return true;
        }
        return count == 0;
    }

    public boolean isInclude() {
        return false;
    }

    public boolean isExclude() {
        return false;
    }

    public int hashCodeForConfig() {
        int h = 0;
        if (this.isExclude()) {
            h += 13;
        }
        FilterRule[] filterRuleArray = this._rules;
        int n = this._rules.length;
        int n2 = 0;
        while (n2 < n) {
            FilterRule fr = filterRuleArray[n2];
            h += fr.hashCodeForConfig();
            ++n2;
        }
        return h;
    }

    public static FilterGroup addRule(FilterGroup baseGroup, FilterRule rule) {
        LinkedList<FilterRule> list = new LinkedList<FilterRule>();
        FilterRule[] filterRuleArray = baseGroup._rules;
        int n = baseGroup._rules.length;
        int n2 = 0;
        while (n2 < n) {
            FilterRule r = filterRuleArray[n2];
            list.add(r);
            ++n2;
        }
        list.add(rule);
        FilterRule[] rules = new FilterRule[list.size()];
        list.toArray(rules);
        return FilterGroup.create(baseGroup.isExclude(), rules);
    }

    public static FilterGroup removeRule(FilterGroup baseGroup, FilterRule rule) {
        LinkedList<FilterRule> list = new LinkedList<FilterRule>();
        FilterRule[] filterRuleArray = baseGroup._rules;
        int n = baseGroup._rules.length;
        int n2 = 0;
        while (n2 < n) {
            FilterRule r = filterRuleArray[n2];
            if (!r.equals(rule)) {
                list.add(r);
            }
            ++n2;
        }
        FilterRule[] rules = new FilterRule[list.size()];
        list.toArray(rules);
        return FilterGroup.create(baseGroup.isExclude(), rules);
    }

    /* synthetic */ FilterGroup(FilterRule[] filterRuleArray, FilterGroup filterGroup) {
        this(filterRuleArray);
    }

    public static final class FilterExcludeGroup
    extends FilterGroup {
        private FilterExcludeGroup(FilterRule[] rules) {
            super(rules, null);
        }

        public String getType() {
            return "exclude";
        }

        public String getDisplayableType() {
            return ValMessages.GroupExclude;
        }

        public boolean isExclude() {
            return true;
        }
    }

    public static final class FilterIncludeGroup
    extends FilterGroup {
        private FilterIncludeGroup(FilterRule[] rules) {
            super(rules, null);
        }

        public String getType() {
            return "include";
        }

        public String getDisplayableType() {
            return ValMessages.GroupInclude;
        }

        public boolean isInclude() {
            return true;
        }
    }
}

