/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeductionGuide;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTDeductionGuide
extends ASTNode
implements ICPPASTDeductionGuide,
IASTAmbiguityParent {
    private IASTParameterDeclaration[] parameters;
    private IASTName templateName;
    private ICPPASTTemplateId templateId;
    private boolean takesVarArgs;
    private boolean isExplicit;

    @Override
    public boolean accept(ASTVisitor visitor) {
        if (visitor.shouldVisitDeclarations) {
            switch (visitor.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.templateName.accept(visitor)) {
            return false;
        }
        if (this.parameters != null) {
            IASTParameterDeclaration[] iASTParameterDeclarationArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                IASTParameterDeclaration parameter = iASTParameterDeclarationArray[n2];
                if (parameter != null && !parameter.accept(visitor)) {
                    return false;
                }
                ++n2;
            }
        }
        if (!this.templateId.accept(visitor)) {
            return false;
        }
        if (visitor.shouldVisitDeclarations) {
            switch (visitor.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void addParameterDeclaration(IASTParameterDeclaration parameter) {
        this.assertNotFrozen();
        assert (parameter != null);
        parameter.setParent(this);
        parameter.setPropertyInParent(PARAMETER);
        this.parameters = ArrayUtil.append(IASTParameterDeclaration.class, this.parameters, parameter);
    }

    @Override
    public IASTParameterDeclaration[] getParameters() {
        if (this.parameters == null) {
            return ICPPASTParameterDeclaration.EMPTY_CPPPARAMETERDECLARATION_ARRAY;
        }
        return ArrayUtil.trim(this.parameters);
    }

    @Override
    public void setVarArgs(boolean value) {
        this.assertNotFrozen();
        this.takesVarArgs = value;
    }

    @Override
    public boolean takesVarArgs() {
        return this.takesVarArgs;
    }

    @Override
    public boolean isExplicit() {
        return this.isExplicit;
    }

    @Override
    public void setExplicit(boolean value) {
        this.assertNotFrozen();
        this.isExplicit = value;
    }

    @Override
    public IASTName getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(IASTName name) {
        this.assertNotFrozen();
        assert (name != null);
        name.setParent(this);
        name.setPropertyInParent(TEMPLATE_NAME);
        this.templateName = name;
    }

    @Override
    public ICPPASTTemplateId getSimpleTemplateId() {
        return this.templateId;
    }

    @Override
    public void setSimpleTemplateId(ICPPASTTemplateId id) {
        this.assertNotFrozen();
        assert (id != null);
        id.setParent(this);
        id.setPropertyInParent(TEMPLATE_ID);
        this.templateId = id;
    }

    @Override
    public ICPPASTDeductionGuide copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public ICPPASTDeductionGuide copy(IASTNode.CopyStyle style) {
        CPPASTDeductionGuide copy = new CPPASTDeductionGuide();
        copy.isExplicit = this.isExplicit;
        copy.takesVarArgs = this.takesVarArgs;
        copy.setTemplateName(this.templateName.copy(style));
        copy.setSimpleTemplateId(this.templateId.copy(style));
        if (this.parameters != null) {
            IASTParameterDeclaration[] iASTParameterDeclarationArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                IASTParameterDeclaration parameter = iASTParameterDeclarationArray[n2];
                if (parameter != null) {
                    copy.addParameterDeclaration(parameter.copy(style));
                }
                ++n2;
            }
        }
        return super.copy(copy, style);
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        int indexOfChild = ArrayUtil.indexOfEqual(this.parameters, child);
        if (indexOfChild > -1) {
            other.setParent(this);
            other.setPropertyInParent(PARAMETER);
            child.setParent(null);
            this.parameters[indexOfChild] = (IASTParameterDeclaration)other;
        }
    }
}

