/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import java.util.Iterator;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IGroupPBSolver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.GroupClauseSelectorSolver;

public class GroupPBSelectorSolver
extends GroupClauseSelectorSolver<IPBSolver>
implements IGroupPBSolver {
    private static final long serialVersionUID = 1L;

    public GroupPBSelectorSolver(IPBSolver solver) {
        super((ISolver)solver);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addPseudoBoolean(lits, coeffs, moreThan, d);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtMost(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtMost(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtLeast(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addAtLeast(literals, coeffs, degree);
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addExactly(literals, coeffs, weight);
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        return ((IPBSolver)this.decorated()).addExactly(literals, coeffs, weight);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction obj) {
        ((IPBSolver)this.decorated()).setObjectiveFunction(obj);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return ((IPBSolver)this.decorated()).getObjectiveFunction();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree, int groupid) throws ContradictionException {
        VecInt coeffs = new VecInt(literals.size(), 1);
        Integer newvar = this.getGroupVar(literals, groupid);
        literals.push(newvar.intValue());
        coeffs.push(degree - coeffs.size());
        return ((IPBSolver)this.decorated()).addAtMost(literals, (IVecInt)coeffs, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree, int groupid) throws ContradictionException {
        VecInt coeffs = new VecInt(literals.size(), 1);
        int newvar = this.getGroupVar(literals, groupid);
        literals.push(newvar);
        coeffs.push(degree);
        return ((IPBSolver)this.decorated()).addAtLeast(literals, (IVecInt)coeffs, degree);
    }

    @Override
    public IConstr addExactly(IVecInt literals, int n, int groupid) throws ContradictionException {
        int newvar = this.getGroupVar(literals, groupid);
        VecInt coeffs = new VecInt(literals.size(), 1);
        literals.push(newvar);
        coeffs.push(n - coeffs.size());
        IConstr constr1 = ((IPBSolver)this.decorated()).addAtMost(literals, (IVecInt)coeffs, n);
        coeffs.pop();
        coeffs.push(n);
        IConstr constr2 = ((IPBSolver)this.decorated()).addAtLeast(literals, (IVecInt)coeffs, n);
        if (constr1 == null && constr2 == null) {
            this.discardLastestVar();
            return null;
        }
        ConstrGroup group = new ConstrGroup();
        group.add(constr1);
        group.add(constr2);
        return group;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree, int groupdId) throws ContradictionException {
        int newvar = this.getGroupVar(literals, groupdId);
        literals.push(newvar);
        BigInteger sum = BigInteger.ZERO;
        Iterator ite = coeffs.iterator();
        while (ite.hasNext()) {
            sum = sum.add((BigInteger)ite.next());
        }
        sum = sum.subtract(degree);
        coeffs.push((Object)sum.negate());
        return ((IPBSolver)this.decorated()).addAtMost(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree, int groupdId) throws ContradictionException {
        int newvar = this.getGroupVar(literals, groupdId);
        literals.push(newvar);
        int sum = 0;
        IteratorInt ite = coeffs.iterator();
        while (ite.hasNext()) {
            sum += ite.next();
        }
        coeffs.push(-(sum -= degree));
        return ((IPBSolver)this.decorated()).addAtMost(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree, int groupId) throws ContradictionException {
        int newvar = this.getGroupVar(literals, groupId);
        literals.push(newvar);
        if (degree >= 0) {
            coeffs.push(degree);
        } else {
            int sum = 0;
            IteratorInt ite = coeffs.iterator();
            while (ite.hasNext()) {
                sum += ite.next();
            }
            coeffs.push(-(sum -= degree));
        }
        return ((IPBSolver)this.decorated()).addAtLeast(literals, coeffs, degree);
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree, int groupId) throws ContradictionException {
        int newvar = this.getGroupVar(literals, groupId);
        literals.push(newvar);
        if (degree.signum() >= 0) {
            coeffs.push((Object)degree);
        } else {
            BigInteger sum = BigInteger.ZERO;
            Iterator ite = coeffs.iterator();
            while (ite.hasNext()) {
                sum = sum.add((BigInteger)ite.next());
            }
            sum = sum.subtract(degree);
            coeffs.push((Object)sum.negate());
        }
        return ((IPBSolver)this.decorated()).addAtLeast(literals, coeffs, degree);
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight, int groupId) throws ContradictionException {
        throw new UnsupportedOperationException("not implemented yet!");
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight, int groupId) throws ContradictionException {
        throw new UnsupportedOperationException("not implemented yet!");
    }
}

