/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import org.eclipse.help.HelpSystem;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.Topic;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.views.HyperlinkTreePart;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AllTopicsPart
extends HyperlinkTreePart {
    private Image containerWithTopicImage;

    public AllTopicsPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm) {
        super(parent, toolkit, tbm);
    }

    @Override
    protected void configureTreeViewer() {
        this.initializeImages();
        this.treeViewer.setContentProvider((IContentProvider)new TopicsProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TopicsLabelProvider());
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                AllTopicsPart.this.postUpdate(event.getElement());
            }

            public void treeExpanded(TreeExpansionEvent event) {
                AllTopicsPart.this.postUpdate(event.getElement());
            }
        });
    }

    @Override
    public void init(ReusableHelpPart parent, String id, IMemento memento) {
        super.init(parent, id, memento);
        if (parent.isFilteredByRoles()) {
            this.treeViewer.addFilter(parent.getRoleFilter());
        }
        this.treeViewer.addFilter(parent.getUAFilter());
        this.treeViewer.addFilter((ViewerFilter)new EmptyContainerFilter());
    }

    private void initializeImages() {
        ImageDescriptor base = HelpUIResources.getImageDescriptor("obj16/container_obj.svg");
        ImageDescriptor ovr = HelpUIResources.getImageDescriptor("ovr16/doc_co.svg");
        DecorationOverlayIcon desc = new DecorationOverlayIcon(base, ovr, 1);
        this.containerWithTopicImage = desc.createImage();
    }

    @Override
    public void dispose() {
        this.containerWithTopicImage.dispose();
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doOpen(Object obj) {
        void res;
        if (!(obj instanceof IHelpResource)) {
            return;
        }
        IHelpResource iHelpResource = (IHelpResource)obj;
        if (res instanceof IToc || res instanceof ITopic && ((ITopic)obj).getSubtopics().length > 0 && res.getHref() == null) {
            this.treeViewer.setExpandedState(obj, !this.treeViewer.getExpandedState((Object)res));
        }
        if (res instanceof IToc) {
            this.postUpdate(res);
        } else if (res.getHref() != null) {
            this.parent.showURL(res.getHref());
        }
    }

    @Override
    protected String getHref(IHelpResource res) {
        return res instanceof ITopic ? res.getHref() : null;
    }

    public void selectReveal(String href) {
        IToc[] tocs;
        IToc[] iTocArray = tocs = HelpSystem.getTocs();
        int n = tocs.length;
        int n2 = 0;
        while (n2 < n) {
            IToc toc = iTocArray[n2];
            ITopic topic = toc.getTopic(href);
            if (topic != null) {
                this.selectReveal((IHelpResource)topic);
                return;
            }
            ++n2;
        }
    }

    public void selectReveal(IHelpResource res) {
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)res), true);
        this.treeViewer.expandToLevel((Object)res, 1);
        this.treeViewer.getControl().setFocus();
    }

    @Override
    protected boolean canAddBookmarks() {
        return true;
    }

    @Override
    public void toggleRoleFilter() {
        if (this.parent.isFilteredByRoles()) {
            this.treeViewer.addFilter(this.parent.getRoleFilter());
        } else {
            this.treeViewer.removeFilter(this.parent.getRoleFilter());
        }
    }

    @Override
    public void saveState(IMemento memento) {
    }

    static class EmptyContainerFilter
    extends ViewerFilter {
        EmptyContainerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IToc) {
                return this.isNotEmpty((IToc)element);
            }
            if (element instanceof ITopic) {
                return this.isNotEmpty((ITopic)element);
            }
            return false;
        }

        private boolean isNotEmpty(IToc toc) {
            ITopic[] topics = toc.getTopics();
            return this.isNotEmpty(topics);
        }

        private boolean isNotEmpty(ITopic topic) {
            String href = topic.getHref();
            ITopic[] topics = topic.getSubtopics();
            return href != null || this.isNotEmpty(topics);
        }

        private boolean isNotEmpty(ITopic[] topics) {
            ITopic[] iTopicArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                ITopic topic = iTopicArray[n2];
                if (this.isNotEmpty(topic)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    class TopicsLabelProvider
    extends LabelProvider {
        TopicsLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof IHelpResource) {
                return ((IHelpResource)obj).getLabel();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            Topic topic;
            Image icon;
            Toc toc;
            Image icon2;
            boolean expanded = AllTopicsPart.this.treeViewer.getExpandedState(obj);
            boolean expandable = AllTopicsPart.this.treeViewer.isExpandable(obj);
            if (obj instanceof Toc && (icon2 = HelpUIResources.getImageFromId((toc = (Toc)obj).getIcon(), expanded, !expandable)) != null) {
                return icon2;
            }
            if (obj instanceof Topic && (icon = HelpUIResources.getImageFromId((topic = (Topic)obj).getIcon(), expanded, !expandable)) != null) {
                return icon;
            }
            if (obj instanceof IToc) {
                String key = expanded ? "obj16/toc_open.svg" : "obj16/toc_closed.svg";
                return HelpUIResources.getImage(key);
            }
            if (obj instanceof ITopic) {
                ITopic topic2 = (ITopic)obj;
                if (expandable && topic2.getHref() != null) {
                    return AllTopicsPart.this.containerWithTopicImage;
                }
                String key = expandable ? "obj16/container_obj.svg" : "obj16/topic_small.svg";
                return HelpUIResources.getImage(key);
            }
            return super.getImage(obj);
        }
    }

    class TopicsProvider
    implements ITreeContentProvider {
        TopicsProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == AllTopicsPart.this) {
                return HelpSystem.getTocs();
            }
            if (parentElement instanceof IToc) {
                return ((IToc)parentElement).getTopics();
            }
            if (parentElement instanceof ITopic) {
                return ((ITopic)parentElement).getSubtopics();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IToc) {
                return AllTopicsPart.this;
            }
            if (element instanceof UAElement) {
                return ((UAElement)element).getParentElement();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

