/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.udp;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.endpoint.ProtocolEndpoint;
import org.eclipse.tracecompass.internal.pcap.core.protocol.udp.UDPPacket;

public class UDPEndpoint
extends ProtocolEndpoint {
    private final int fPort;

    public UDPEndpoint(UDPPacket packet, boolean isSourceEndpoint) {
        super(packet, isSourceEndpoint);
        this.fPort = isSourceEndpoint ? packet.getSourcePort() : packet.getDestinationPort();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        result = endpoint == null ? 0 : endpoint.hashCode();
        result = 31 * result + this.fPort;
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        boolean localEquals;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UDPEndpoint)) {
            return false;
        }
        UDPEndpoint other = (UDPEndpoint)obj;
        boolean bl = localEquals = this.fPort == other.fPort;
        if (!localEquals) {
            return false;
        }
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        if (endpoint != null) {
            return endpoint.equals(other.getParentEndpoint());
        }
        return true;
    }

    @Override
    public String toString() {
        ProtocolEndpoint endpoint = this.getParentEndpoint();
        if (endpoint == null) {
            return String.valueOf(this.fPort);
        }
        return endpoint.toString() + "/" + this.fPort;
    }
}

