/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDefinition;
import org.eclipse.tracecompass.ctf.core.tests.io.Util;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDeclaration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariantDefinitionTest {
    private VariantDefinition fixture;
    StructDefinition fStructDefinition;
    private static final @NonNull String TEST_STRUCT_ID = "testStruct";
    private static final @NonNull String ENUM_7 = "g";
    private static final @NonNull String ENUM_6 = "f";
    private static final @NonNull String ENUM_5 = "e";
    private static final @NonNull String ENUM_4 = "d";
    private static final @NonNull String ENUM_3 = "c";
    private static final @NonNull String ENUM_2 = "b";
    private static final @NonNull String ENUM_1 = "a";
    private static final @NonNull String TAG_ID = "a";
    private static final @NonNull String LENGTH_SEQ = "_len";
    private static final @NonNull String VAR_FIELD_NAME = "var";
    private static final @NonNull String ENUM_8 = "bbq ribs";

    @Before
    public void setUp() throws CTFException {
        StructDeclaration sDec = new StructDeclaration(12L);
        StructDeclaration smallStruct = new StructDeclaration(8L);
        IntegerDeclaration iDec = IntegerDeclaration.createDeclaration((int)32, (boolean)false, (int)32, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)8L, null);
        IntegerDeclaration lenDec = IntegerDeclaration.createDeclaration((int)8, (boolean)false, (int)8, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.NONE, (String)"", (long)8L, null);
        StringDeclaration strDec = StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8);
        EnumDeclaration enDec = new EnumDeclaration(iDec);
        VariantDeclaration varDec = new VariantDeclaration();
        EnumDeclaration tagDec = new EnumDeclaration(iDec);
        ArrayDeclaration arrDec = new ArrayDeclaration(2, (IDeclaration)iDec);
        FloatDeclaration fDec = new FloatDeclaration(8, 24, ByteOrder.BIG_ENDIAN, 8L);
        tagDec.add(0L, 1L, "a");
        tagDec.add(2L, 3L, ENUM_2);
        tagDec.add(4L, 5L, ENUM_3);
        tagDec.add(8L, 9L, ENUM_5);
        tagDec.add(10L, 11L, ENUM_6);
        tagDec.add(12L, 13L, ENUM_7);
        varDec.addField(ENUM_4, (IDeclaration)lenDec);
        varDec.addField(ENUM_7, (IDeclaration)fDec);
        varDec.addField(ENUM_6, (IDeclaration)smallStruct);
        varDec.addField(ENUM_5, (IDeclaration)enDec);
        varDec.addField(ENUM_3, (IDeclaration)arrDec);
        varDec.addField(ENUM_2, (IDeclaration)iDec);
        varDec.addField("a", (IDeclaration)strDec);
        sDec.addField("a", (IDeclaration)tagDec);
        sDec.addField(LENGTH_SEQ, (IDeclaration)lenDec);
        sDec.addField(VAR_FIELD_NAME, (IDeclaration)varDec);
        varDec.setTag("a");
        ByteBuffer byteBuffer = Util.testMemory(ByteBuffer.allocate(100));
        BitBuffer bb = new BitBuffer(byteBuffer);
        byteBuffer.mark();
        byteBuffer.putInt(1);
        byteBuffer.putInt(2);
        byteBuffer.putInt(3);
        byteBuffer.reset();
        this.fStructDefinition = sDec.createDefinition(null, TEST_STRUCT_ID, bb);
        this.fixture = (VariantDefinition)this.fStructDefinition.getDefinition(VAR_FIELD_NAME);
    }

    @Test
    public void testVariantDefinition() throws CTFException {
        VariantDeclaration declaration = new VariantDeclaration();
        declaration.setTag("");
        VariantDeclaration variantDeclaration = new VariantDeclaration();
        variantDeclaration.addField("", (IDeclaration)new EnumDeclaration(IntegerDeclaration.INT_32B_DECL));
        variantDeclaration.addField("a", (IDeclaration)IntegerDeclaration.INT_64B_DECL);
        declaration.addField(ENUM_3, (IDeclaration)StringDeclaration.getStringDeclaration((Encoding)Encoding.UTF8));
        variantDeclaration.setTag("a");
        byte[] bytes = new byte[128];
        ByteBuffer byb = ByteBuffer.wrap(bytes);
        byb.mark();
        byb.putInt(0);
        byb.putShort((short)2);
        byb.put(new String("hello").getBytes());
        byb.reset();
        BitBuffer bb = new BitBuffer(byb);
        VariantDefinition variantDefinition = variantDeclaration.createDefinition((IDefinitionScope)this.fStructDefinition, "field", bb);
        EnumDeclaration declaration2 = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        declaration2.add(0L, 2L, ENUM_3);
        EnumDefinition enumDefinition = new EnumDefinition(declaration2, null, "a", new IntegerDefinition(IntegerDeclaration.INT_8_DECL, null, "A", 1L));
        StructDeclaration declarationScope = new StructDeclaration(1L);
        declarationScope.addField("", (IDeclaration)enumDefinition.getDeclaration());
        declarationScope.addField("variant", (IDeclaration)variantDeclaration);
        StructDefinition definitionScope = new StructDefinition(declarationScope, (IDefinitionScope)variantDefinition, "", new Definition[]{enumDefinition, variantDefinition});
        String fieldName = "";
        declaration.setTag("");
        VariantDefinition result = declaration.createDefinition((IDefinitionScope)definitionScope, fieldName, bb);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetCurrentField() {
        Definition result = this.fixture.getCurrentField();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetCurrentFieldName() {
        String result = this.fixture.getCurrentFieldName();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDeclaration() {
        VariantDeclaration result = this.fixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDefinitions() {
        Definition result = this.fixture.getCurrentField();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetPath() {
        String result = this.fixture.getScopePath().getPath();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testLookupArray() {
        AbstractArrayDefinition result = this.fixture.lookupArrayDefinition(ENUM_3);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupDefinition() {
        IDefinition result = this.fixture.lookupDefinition("a");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"a", (Object)((EnumDefinition)result).getStringValue());
    }

    @Test
    public void testLookupEnum() {
        EnumDefinition result = this.fixture.lookupEnum(ENUM_5);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupInteger() {
        IntegerDefinition result = this.fixture.lookupInteger(ENUM_2);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupString() {
        StringDefinition result = this.fixture.lookupString("a");
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupStruct() {
        StructDefinition result = this.fixture.lookupStruct(ENUM_6);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testLookupVariant() {
        VariantDefinition result = this.fixture.lookupVariant(ENUM_8);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        Assert.assertEquals((Object)"{ a = \"\" }", (Object)result);
    }
}

