/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.util.Map;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;

public class FixedShingleFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "fixedShingle";
    private final int shingleSize;
    private final String tokenSeparator;
    private final String fillerToken;

    public FixedShingleFilterFactory(Map<String, String> args) {
        super(args);
        this.shingleSize = this.getInt(args, "shingleSize", 2);
        this.tokenSeparator = this.get(args, "tokenSeparator", " ");
        this.fillerToken = this.get(args, "fillerToken", "_");
    }

    public FixedShingleFilterFactory() {
        throw FixedShingleFilterFactory.defaultCtorException();
    }

    public TokenStream create(TokenStream input) {
        return new FixedShingleFilter(input, this.shingleSize, this.tokenSeparator, this.fillerToken);
    }
}

