/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatisticsAnalysis;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.AbstractSegmentStoreStatisticsDataProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.IDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsAspects;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentStoreStatisticsDataProvider
extends AbstractSegmentStoreStatisticsDataProvider {
    public static final String ID = "org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider";
    private static final String STATISTICS_SUFFIX = ".statistics";
    private static final Map<IStatisticsAnalysis, SegmentStoreStatisticsDataProvider> PROVIDER_MAP = new WeakHashMap<IStatisticsAnalysis, SegmentStoreStatisticsDataProvider>();
    private final IStatisticsAnalysis fProvider;
    private final @Nullable IAnalysisModule fModule;

    public static synchronized @Nullable SegmentStoreStatisticsDataProvider getOrCreate(ITmfTrace trace, AbstractSegmentStatisticsAnalysis module) {
        return PROVIDER_MAP.computeIfAbsent(module, p -> new SegmentStoreStatisticsDataProvider(trace, (IStatisticsAnalysis)p, module.getId() + STATISTICS_SUFFIX));
    }

    public SegmentStoreStatisticsDataProvider(ITmfTrace trace, IStatisticsAnalysis provider, String id) {
        super(trace, id);
        this.fProvider = provider;
        this.fModule = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
    }

    public SegmentStoreStatisticsDataProvider(ITmfTrace trace, IStatisticsAnalysis provider, String id, List<IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics>> userDefinedAspects) {
        super(trace, id, userDefinedAspects);
        this.fProvider = provider;
        this.fModule = provider instanceof IAnalysisModule ? (IAnalysisModule)provider : null;
    }

    public TmfModelResponse<TmfTreeModel<SegmentStoreStatisticsModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        IStatistics<ISegment> statsTotal;
        IAnalysisModule module = this.fModule;
        if (module != null) {
            if (monitor != null) {
                module.waitForCompletion(monitor);
                if (monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
            } else {
                module.waitForCompletion();
            }
        }
        if ((statsTotal = this.fProvider.getStatsTotal()) == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ArrayList<SegmentStoreStatisticsModel> list = new ArrayList<SegmentStoreStatisticsModel>();
        String rootName = this.getRootEntryName();
        if (rootName == null) {
            rootName = this.getTrace().getName();
        }
        list.add(new SegmentStoreStatisticsModel(this.fTraceId, -1L, this.getCellLabels(NonNullUtils.nullToEmptyString((Object)rootName), statsTotal), statsTotal));
        long totalId = this.getUniqueId("Total_");
        list.add(new SegmentStoreStatisticsModel(totalId, this.fTraceId, this.getCellLabels(Objects.requireNonNull(Messages.SegmentStoreStatisticsDataProvider_Total), statsTotal), statsTotal));
        Map totalStats = this.fProvider.getStatsPerType();
        for (Map.Entry entry : totalStats.entrySet()) {
            IStatistics<ISegment> statistics = entry.getValue();
            list.add(new SegmentStoreStatisticsModel(this.getUniqueId("Total_" + entry.getKey()), totalId, this.getCellLabels(entry.getKey(), statistics), statistics));
        }
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        Boolean isFiltered = DataProviderParameterUtils.extractIsFiltered(fetchParameters);
        if (filter != null && isFiltered != null && isFiltered.booleanValue()) {
            IProgressMonitor nonNullMonitor;
            long end;
            long start = filter.getStart();
            IStatistics<ISegment> statsForRange = this.fProvider.getStatsForRange(start, end = filter.getEnd(), nonNullMonitor = monitor != null ? monitor : new NullProgressMonitor());
            if (statsForRange == null) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            long selectionId = this.getUniqueId("Selection_");
            if (statsForRange.getNbElements() > 0L) {
                list.add(new SegmentStoreStatisticsModel(selectionId, this.fTraceId, this.getCellLabels(Objects.requireNonNull(Messages.SegmentStoreStatisticsDataProvider_Selection), statsForRange), statsForRange));
                Map selectionStats = this.fProvider.getStatsPerTypeForRange(start, end, nonNullMonitor);
                for (Map.Entry entry : selectionStats.entrySet()) {
                    IStatistics<ISegment> statistics = entry.getValue();
                    list.add(new SegmentStoreStatisticsModel(this.getUniqueId("Selection_" + entry.getKey()), selectionId, this.getCellLabels(entry.getKey(), statistics), statistics));
                }
            }
        }
        TmfTreeModel.Builder treeModelBuilder = new TmfTreeModel.Builder();
        treeModelBuilder.setColumnDescriptors(this.getColumnDescriptors());
        treeModelBuilder.setEntries(Collections.unmodifiableList(list));
        return new TmfModelResponse((Object)treeModelBuilder.build(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fModule != null) {
            this.fModule.dispose();
        }
    }
}

