/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.ScannerProvider;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.settings.model.AbstractCExtensionProxy;
import org.eclipse.cdt.internal.core.settings.model.DescriptionScannerInfoProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ScannerInfoProviderProxy
extends AbstractCExtensionProxy
implements IScannerInfoProvider,
IScannerInfoChangeListener {
    private Map<IProject, List<IScannerInfoChangeListener>> listeners;
    private IScannerInfoProvider fProvider;

    public ScannerInfoProviderProxy(IProject project) {
        super(project, "org.eclipse.cdt.core.ScannerInfoProvider");
    }

    @Override
    public IScannerInfo getScannerInformation(IResource resource) {
        this.providerRequested();
        return this.fProvider.getScannerInformation(resource);
    }

    protected void notifyInfoListeners(IResource rc, IScannerInfo info) {
        List<IScannerInfoChangeListener> listeners = this.getListeners().get(rc);
        if (listeners == null) {
            return;
        }
        IScannerInfoChangeListener[] observers = new IScannerInfoChangeListener[listeners.size()];
        listeners.toArray(observers);
        int i = 0;
        while (i < observers.length) {
            observers[i].changeNotification(rc, info);
            ++i;
        }
    }

    @Override
    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        if (resource == null || listener == null) {
            return;
        }
        IProject project = resource.getProject();
        Map<IProject, List<IScannerInfoChangeListener>> map = this.getListeners();
        List<IScannerInfoChangeListener> list = map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
            map.put(project, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    private Map<IProject, List<IScannerInfoChangeListener>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashMap<IProject, List<IScannerInfoChangeListener>>();
        }
        return this.listeners;
    }

    @Override
    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        if (resource == null || listener == null) {
            return;
        }
        IProject project = resource.getProject();
        Map<IProject, List<IScannerInfoChangeListener>> map = this.getListeners();
        List<IScannerInfoChangeListener> list = map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
        }
    }

    @Override
    public void changeNotification(IResource rc, IScannerInfo info) {
        this.notifyInfoListeners(rc, info);
    }

    @Override
    protected Object createDefaultProvider(ICConfigurationDescription des, boolean newStile) {
        if (newStile) {
            return new DescriptionScannerInfoProvider(this.getProject());
        }
        return ScannerProvider.getInstance();
    }

    @Override
    protected void deinitializeProvider(Object o) {
        IScannerInfoProvider provider = (IScannerInfoProvider)o;
        provider.unsubscribe((IResource)this.getProject(), this);
        if (provider instanceof DescriptionScannerInfoProvider) {
            ((DescriptionScannerInfoProvider)provider).close();
        }
    }

    @Override
    protected void initializeProvider(Object o) {
        IScannerInfoProvider provider;
        this.fProvider = provider = (IScannerInfoProvider)o;
        provider.subscribe((IResource)this.getProject(), this);
    }

    @Override
    protected void postProcessProviderChange(Object newProvider, Object oldProvider) {
        if (oldProvider != null) {
            this.notifyInfoListeners((IResource)this.getProject(), this.getScannerInformation((IResource)this.getProject()));
        }
    }

    @Override
    protected boolean isValidProvider(Object o) {
        return o instanceof IScannerInfoProvider;
    }
}

