/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTAttributeOwner;

public class CPPASTNamespaceDefinition
extends CPPASTAttributeOwner
implements ICPPASTNamespaceDefinition {
    private IASTName fName;
    private IASTDeclaration[] fAllDeclarations;
    private IASTDeclaration[] fActiveDeclarations;
    private int fLastDeclaration = -1;
    private boolean fIsInline;

    public CPPASTNamespaceDefinition() {
    }

    public CPPASTNamespaceDefinition(IASTName name) {
        this.setName(name);
    }

    @Override
    public CPPASTNamespaceDefinition copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTNamespaceDefinition copy(IASTNode.CopyStyle style) {
        CPPASTNamespaceDefinition copy = new CPPASTNamespaceDefinition(this.fName == null ? null : this.fName.copy(style));
        copy.fIsInline = this.fIsInline;
        IASTDeclaration[] iASTDeclarationArray = this.getDeclarations();
        int n = iASTDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration declaration = iASTDeclarationArray[n2];
            copy.addDeclaration(declaration == null ? null : declaration.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTName getName() {
        return this.fName;
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.fName = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(NAMESPACE_NAME);
        }
    }

    @Override
    public void setIsInline(boolean isInline) {
        this.assertNotFrozen();
        this.fIsInline = isInline;
    }

    @Override
    public boolean isInline() {
        return this.fIsInline;
    }

    @Override
    public final void addDeclaration(IASTDeclaration decl) {
        if (decl != null) {
            decl.setParent(this);
            decl.setPropertyInParent(OWNED_DECLARATION);
            this.fAllDeclarations = ArrayUtil.appendAt(IASTDeclaration.class, this.fAllDeclarations, ++this.fLastDeclaration, decl);
            this.fActiveDeclarations = null;
        }
    }

    @Override
    public final IASTDeclaration[] getDeclarations() {
        IASTDeclaration[] active = this.fActiveDeclarations;
        if (active == null) {
            active = ASTQueries.extractActiveDeclarations(this.fAllDeclarations, this.fLastDeclaration + 1);
            this.fActiveDeclarations = active;
        }
        return active;
    }

    @Override
    public final IASTDeclaration[] getDeclarations(boolean includeInactive) {
        if (includeInactive) {
            this.fAllDeclarations = ArrayUtil.trimAt(IASTDeclaration.class, this.fAllDeclarations, this.fLastDeclaration);
            return this.fAllDeclarations;
        }
        return this.getDeclarations();
    }

    @Override
    public IScope getScope() {
        return ((ICPPNamespace)this.fName.resolveBinding()).getNamespaceScope();
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTDeclaration[] decls;
        if (action.shouldVisitNamespaces) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByCPPAttributeSpecifiers(action)) {
            return false;
        }
        if (this.fName != null && !this.fName.accept(action)) {
            return false;
        }
        if (!this.acceptByGCCAttributeSpecifiers(action)) {
            return false;
        }
        IASTDeclaration[] iASTDeclarationArray = decls = this.getDeclarations(action.includeInactiveNodes);
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (!decl.accept(action)) {
                return false;
            }
            ++n2;
        }
        return !action.shouldVisitNamespaces || action.leave(this) != 2;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (this.fName == n) {
            return 2;
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        assert (child.isActive() == other.isActive());
        int i = 0;
        while (i <= this.fLastDeclaration) {
            if (this.fAllDeclarations[i] == child) {
                other.setParent(child.getParent());
                other.setPropertyInParent(child.getPropertyInParent());
                this.fAllDeclarations[i] = (IASTDeclaration)other;
                this.fActiveDeclarations = null;
                return;
            }
            ++i;
        }
        super.replace(child, other);
    }
}

