/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text.codemining.annotation;

import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

@NonNullByDefault
public class AnnotationCodeMining
extends LineHeaderCodeMining {
    private final Annotation annotation;
    private final IAnnotationAccessExtension annotationAccess;

    public AnnotationCodeMining(IAnnotationAccessExtension annotationAccess, Annotation annotation, int lineNumber, IDocument document, ICodeMiningProvider provider, @Nullable Consumer<MouseEvent> action) throws BadLocationException {
        super(lineNumber, document, provider, action);
        this.annotationAccess = annotationAccess;
        String text = annotation.getText();
        if (text != null) {
            this.setLabel(AnnotationCodeMining.sanitizeLabel(text));
        }
        this.annotation = annotation;
    }

    private static String sanitizeLabel(String label) {
        return label.replace('\r', ' ').replace('\n', ' ');
    }

    public Point draw(GC gc, StyledText textWidget, Color color, int x, int y) {
        int width = 16;
        this.annotationAccess.paint(this.annotation, gc, (Canvas)textWidget, new Rectangle(x, y, 16, 16));
        Point result = super.draw(gc, textWidget, color, x + 16, y);
        result.x += 16;
        return result;
    }
}

