/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.rewrite;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTLiteralNode;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModificationStore;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.ASTCommenter;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.text.edits.TextEditGroup;

public final class ASTRewrite {
    private final IASTNode fRoot;
    private final ASTModificationStore fModificationStore;
    private final ASTModification fParentMod;
    private final NodeCommentMap fCommentMap;

    public static ASTRewrite create(IASTTranslationUnit node) {
        NodeCommentMap commentMap = ASTCommenter.getCommentedNodeMap(node);
        return new ASTRewrite(node, new ASTModificationStore(), null, commentMap);
    }

    private ASTRewrite(IASTNode root, ASTModificationStore modStore, ASTModification parentMod, NodeCommentMap commentMap) {
        this.fRoot = root;
        this.fModificationStore = modStore;
        this.fParentMod = parentMod;
        this.fCommentMap = commentMap;
    }

    public final IASTNode createLiteralNode(String code) {
        return new ASTLiteralNode(code);
    }

    public final void remove(IASTNode node, TextEditGroup editGroup) {
        this.checkBelongsToAST(node);
        this.checkSupportedNode(node, Operation.remove);
        ASTModification mod = new ASTModification(ASTModification.ModificationKind.REPLACE, node, null, editGroup);
        this.fModificationStore.storeModification(this.fParentMod, mod);
    }

    public final ASTRewrite replace(IASTNode node, IASTNode replacement, TextEditGroup editGroup) {
        if (replacement == null) {
            throw new IllegalArgumentException();
        }
        this.checkBelongsToAST(node);
        this.checkSupportedNode(node, Operation.replace);
        this.checkSupportedNode(replacement, Operation.replace);
        ASTModification mod = new ASTModification(ASTModification.ModificationKind.REPLACE, node, replacement, editGroup);
        this.fModificationStore.storeModification(this.fParentMod, mod);
        return new ASTRewrite(replacement, this.fModificationStore, mod, this.fCommentMap);
    }

    public final ASTRewrite insertBefore(IASTNode parent, IASTNode insertionPoint, IASTNode newNode, TextEditGroup editGroup) {
        ASTModification mod;
        this.checkBelongsToAST(parent);
        if (newNode == null) {
            throw new IllegalArgumentException();
        }
        this.checkSupportedNode(parent, Operation.insertBefore);
        this.checkSupportedNode(insertionPoint, Operation.insertBefore);
        this.checkSupportedNode(newNode, Operation.insertBefore);
        if (insertionPoint == null) {
            mod = new ASTModification(ASTModification.ModificationKind.APPEND_CHILD, parent, newNode, editGroup);
        } else {
            if (insertionPoint.getParent() != parent) {
                throw new IllegalArgumentException();
            }
            mod = new ASTModification(ASTModification.ModificationKind.INSERT_BEFORE, insertionPoint, newNode, editGroup);
        }
        ASTCommenter.addCommentsToMap(newNode.getTranslationUnit(), this.fCommentMap);
        this.fModificationStore.storeModification(this.fParentMod, mod);
        return new ASTRewrite(newNode, this.fModificationStore, mod, this.fCommentMap);
    }

    public Change rewriteAST() {
        if (!(this.fRoot instanceof IASTTranslationUnit)) {
            throw new IllegalArgumentException("This API can only be used for the root rewrite object.");
        }
        return ASTRewriteAnalyzer.rewriteAST((IASTTranslationUnit)this.fRoot, this.fModificationStore, this.fCommentMap);
    }

    private void checkBelongsToAST(IASTNode node) {
        while (node != null) {
            if (node == this.fRoot) {
                return;
            }
            node = node.getParent();
        }
        throw new IllegalArgumentException();
    }

    private void checkSupportedNode(IASTNode node, Operation op) {
        if (node instanceof IASTComment && op != Operation.remove) {
            throw new IllegalArgumentException("Rewriting comments is not yet supported");
        }
        if (node instanceof IASTPreprocessorStatement) {
            throw new IllegalArgumentException("Rewriting preprocessor statements is not yet supported");
        }
        if (node instanceof IASTProblem) {
            throw new IllegalArgumentException("Rewriting problem nodes is not supported");
        }
    }

    public void addComment(IASTNode node, IASTComment comment, CommentPosition pos) {
        switch (pos) {
            case leading: {
                this.fCommentMap.addLeadingCommentToNode(node, comment);
                break;
            }
            case trailing: {
                this.fCommentMap.addTrailingCommentToNode(node, comment);
                break;
            }
            case freestanding: {
                this.fCommentMap.addFreestandingCommentToNode(node, comment);
            }
        }
    }

    public void removeComment(IASTNode node, IASTComment comment) {
        this.fCommentMap.removeCommentFromNode(node, comment);
    }

    public void removeComments(IASTNode node, CommentPosition pos) {
        switch (pos) {
            case leading: {
                this.fCommentMap.removeLeadingCommentsFromNode(node);
                break;
            }
            case trailing: {
                this.fCommentMap.removeTrailingCommentsFromNode(node);
                break;
            }
            case freestanding: {
                this.fCommentMap.removeFreestandingCommentsFromNode(node);
            }
        }
    }

    public void removeAllComments(IASTNode node) {
        this.fCommentMap.removeAllComments(node);
    }

    public List<IASTComment> getComments(IASTNode node, CommentPosition pos) {
        switch (pos) {
            case leading: {
                return this.fCommentMap.getLeadingCommentsForNode(node);
            }
            case trailing: {
                return this.fCommentMap.getTrailingCommentsForNode(node);
            }
            case freestanding: {
                return this.fCommentMap.getFreestandingCommentsForNode(node);
            }
        }
        return this.fCommentMap.getLeadingCommentsForNode(node);
    }

    public static enum CommentPosition {
        leading,
        trailing,
        freestanding;

    }

    private static enum Operation {
        insertBefore,
        replace,
        remove;

    }
}

