/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ISelectCommandScriptDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.ui.IWorkbenchPage;

public class ExecuteCommandScriptHandler
extends BaseControlViewHandler {
    private @Nullable TraceSessionGroup fSessionGroup = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TraceSessionGroup tmpGroup = null;
        this.fLock.lock();
        try {
            tmpGroup = this.fSessionGroup;
        }
        finally {
            this.fLock.unlock();
        }
        final TraceSessionGroup sessionGroup = tmpGroup;
        if (sessionGroup == null) {
            return null;
        }
        final ISelectCommandScriptDialog dialog = TraceControlDialogFactory.getInstance().getCommandScriptDialog();
        if (dialog.open() != 0) {
            return null;
        }
        Job job = new Job(Messages.TraceControl_ExecuteScriptJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    sessionGroup.executeCommands(monitor, dialog.getCommands());
                }
                catch (ExecutionException e) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_CreateSessionFailure, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceSessionGroup sessionGroup = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            Object element = ((StructuredSelection)selection).getFirstElement();
            sessionGroup = element instanceof TraceSessionGroup ? (TraceSessionGroup)element : null;
        }
        boolean isEnabled = sessionGroup != null;
        this.fLock.lock();
        try {
            this.fSessionGroup = null;
            if (isEnabled) {
                this.fSessionGroup = sessionGroup;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

