/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.libfolders;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class OpenedAndChangedProjectsFinder
implements IResourceDeltaVisitor {
    private IResourceDelta fDelta;
    private Collection<IProject> fFoundProjects;

    public OpenedAndChangedProjectsFinder(IResourceDelta delta) {
        this.fDelta = delta;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        switch (resource.getType()) {
            case 8: {
                return this.visitWorkspaceRoot(delta);
            }
            case 4: {
                return this.visitProject(delta);
            }
            case 2: {
                return this.visitFolder(delta);
            }
        }
        return false;
    }

    public IProject[] getFoundProjects() {
        if (this.fFoundProjects == null) {
            this.fFoundProjects = new HashSet<IProject>();
            try {
                this.fDelta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
        }
        return this.fFoundProjects.toArray(new IProject[this.fFoundProjects.size()]);
    }

    private boolean visitWorkspaceRoot(IResourceDelta delta) {
        return delta.getKind() == 4;
    }

    private boolean visitProject(IResourceDelta delta) throws CoreException {
        if ((delta.getFlags() & 0x84000) == 0) {
            return true;
        }
        IProject project = (IProject)delta.getResource();
        if (!project.isOpen()) {
            return false;
        }
        if (!project.hasNature("org.eclipse.php.core.PHPNature")) {
            return false;
        }
        this.fFoundProjects.add(project);
        return false;
    }

    private boolean visitFolder(IResourceDelta delta) {
        if (delta.getKind() == 1) {
            IProject project = delta.getResource().getProject();
            this.fFoundProjects.add(project);
            return false;
        }
        return true;
    }
}

