/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.test;

import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.api.objects.Autoload;
import org.eclipse.php.composer.api.objects.Namespace;
import org.eclipse.php.composer.api.test.ComposertTestCase;
import org.junit.Test;

public class AutoloadTest
extends ComposertTestCase {
    @Test
    public void testNamespace() {
        Namespace ns = new Namespace();
        ns.setNamespace("bla");
        AutoloadTest.assertEquals((String)"bla", (String)ns.getNamespace());
    }

    @Test
    public void testPsr0() throws IOException, URISyntaxException {
        ComposerPackage composerPackage = new ComposerPackage();
        composerPackage.getAutoload().getPsr0().clear();
        Namespace ns = new Namespace();
        ns.setNamespace("foo");
        ns.add("bar");
        composerPackage.getAutoload().getPsr0().add(ns);
        AutoloadTest.assertEquals((int)1, (int)composerPackage.getAutoload().getPsr0().size());
        Namespace namespace = (Namespace)composerPackage.getAutoload().getPsr0().get("foo");
        AutoloadTest.assertNotNull((Object)namespace);
        AutoloadTest.assertEquals((Object)"bar", (Object)namespace.getPaths().get(0));
    }

    @Test
    public void testPsr0Escaping() throws ParseException {
        Psr psr0 = new Psr();
        Namespace ns = new Namespace("Symfony\\Component\\Yaml", "symfony/yaml");
        psr0.add(ns);
        String json = psr0.toJson();
        psr0 = new Psr(json);
        AutoloadTest.assertEquals((int)1, (int)psr0.getNamespaces().size());
    }

    @Test
    public void testParse() throws IOException, ParseException, URISyntaxException {
        ComposerPackage composerPackage = new ComposerPackage(this.loadFile("autoload.json"));
        Autoload autoload = composerPackage.getAutoload();
        Psr psr0 = autoload.getPsr0();
        AutoloadTest.assertNotNull((Object)psr0);
        AutoloadTest.assertEquals((int)4, (int)psr0.size());
        AutoloadTest.assertTrue((boolean)psr0.has(""));
        AutoloadTest.assertTrue((boolean)psr0.has("gossi"));
        AutoloadTest.assertTrue((boolean)psr0.has("Monolog"));
        AutoloadTest.assertTrue((boolean)psr0.has("UniqueGlobalClass"));
        AutoloadTest.assertEquals((int)2, (int)((Namespace)psr0.get("Monolog")).size());
        AutoloadTest.assertEquals((String)"etc/", (String)((Namespace)psr0.get("")).getFirst());
        AutoloadTest.assertEquals((int)3, (int)autoload.getClassMap().size());
        AutoloadTest.assertEquals((int)1, (int)autoload.getFiles().size());
    }

    @Test
    public void testParseDev() throws IOException, ParseException, URISyntaxException {
        ComposerPackage composerPackage = new ComposerPackage(this.loadFile("autoload.json"));
        Autoload autoload = composerPackage.getAutoloadDev();
        Psr psr0 = autoload.getPsr0();
        AutoloadTest.assertNotNull((Object)psr0);
        AutoloadTest.assertEquals((int)4, (int)psr0.size());
        AutoloadTest.assertTrue((boolean)psr0.has(""));
        AutoloadTest.assertTrue((boolean)psr0.has("gossi"));
        AutoloadTest.assertTrue((boolean)psr0.has("Monolog"));
        AutoloadTest.assertTrue((boolean)psr0.has("UniqueGlobalClass"));
        AutoloadTest.assertEquals((int)2, (int)((Namespace)psr0.get("Monolog")).size());
        AutoloadTest.assertEquals((String)"etc/", (String)((Namespace)psr0.get("")).getFirst());
        AutoloadTest.assertEquals((int)3, (int)autoload.getClassMap().size());
        AutoloadTest.assertEquals((int)1, (int)autoload.getFiles().size());
    }

    @Test
    public void testFromString() throws ParseException {
        Psr psr0 = new Psr("{ \"Foo\" : \"Bar\", \"What\" : \"Ever\"}");
        AutoloadTest.assertEquals((int)2, (int)psr0.size());
        AutoloadTest.assertEquals((String)"Foo", (String)psr0.getFirst().getNamespace());
    }

    @Test
    public void testSearch() throws IOException, ParseException, URISyntaxException {
        ComposerPackage composerPackage = new ComposerPackage(this.loadFile("autoload.json"));
        Autoload autoload = composerPackage.getAutoload();
        Psr psr0 = autoload.getPsr0();
        AutoloadTest.assertTrue((boolean)psr0.hasPath("src/gossi"));
        Namespace ns = psr0.getNamespaceForPath("src/gossi");
        AutoloadTest.assertNotNull((Object)ns);
        AutoloadTest.assertEquals((String)"gossi", (String)ns.getNamespace());
    }

    @Test
    public void testNamespaceEquals() {
        Namespace n1;
        Namespace n2 = n1 = new Namespace();
        AutoloadTest.assertTrue((boolean)n1.equals((Object)n2));
        n1.setNamespace("test");
        n2 = n1.clone();
        AutoloadTest.assertTrue((boolean)n1.equals((Object)n2));
        n1 = new Namespace();
        n1.add("bla");
        n2 = n1.clone();
        AutoloadTest.assertTrue((boolean)n1.equals((Object)n2));
        n1.add("boink");
        n2 = n1.clone();
        AutoloadTest.assertTrue((boolean)n1.equals((Object)n2));
        n1 = new Namespace();
        n1.setNamespace("test");
        n2 = new Namespace();
        n2.setNamespace("wurst");
        AutoloadTest.assertFalse((boolean)n1.equals((Object)n2));
        n1 = new Namespace();
        n1.add("bla");
        n2 = new Namespace();
        n2.add("boink");
        AutoloadTest.assertFalse((boolean)n1.equals((Object)n2));
        n1 = new Namespace();
        n1.setNamespace("test");
        n2 = new Namespace();
        n2.add("boink");
        AutoloadTest.assertFalse((boolean)n1.equals((Object)n2));
        n1 = new Namespace();
        n1.add("boink");
        n2 = new Namespace();
        n2.setNamespace("test");
        AutoloadTest.assertFalse((boolean)n1.equals((Object)n2));
        n1 = new Namespace();
        n1.setNamespace("test");
        n1.add("bla");
        n2 = new Namespace();
        n2.setNamespace("test");
        n2.add("boink");
        AutoloadTest.assertFalse((boolean)n1.equals((Object)n2));
    }
}

