/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IImportDeclaration;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.PHPUiPlugin;

public class PHPElementLabels
extends ScriptElementLabels {
    private static final String MIXED_RETURN_TYPE = "mixed";
    private static final String VOID_RETURN_TYPE = "void";
    private static final String QUESTION_MARK = "?";
    public static final String REFERENCE_STRING = "&";

    protected void getTypeLabel(IType type, long flags, StringBuffer buf) {
        Object typeName;
        if (PHPElementLabels.getFlag((long)flags, (long)786432L)) {
            int parentType;
            IType declaringType;
            IModelElement elem = type.getParent();
            IType iType = declaringType = elem instanceof IType ? (IType)elem : null;
            if (declaringType != null) {
                this.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, buf);
                buf.append(this.getTypeDelimiter(elem));
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8) {
                this.getElementLabel(type.getParent(), (parentType == 9 ? 128L : 65536L) | flags & 0x1002000000000L, buf);
                buf.append(this.getTypeDelimiter(elem));
            }
        }
        if (((String)(typeName = type.getElementName())).length() == 0) {
            try {
                if (type.getParent() instanceof IField) {
                    typeName = "{...}";
                } else {
                    String[] superNames = type.getSuperClasses();
                    if (superNames != null) {
                        int count = 0;
                        typeName = (String)typeName + " : ";
                        int i = 0;
                        while (i < superNames.length) {
                            if (count > 0) {
                                typeName = (String)typeName + ",  ";
                            }
                            typeName = (String)typeName + superNames[i];
                            ++count;
                            ++i;
                        }
                    }
                }
            }
            catch (ModelException e) {
                typeName = "";
            }
        }
        buf.append((String)typeName);
        if (PHPElementLabels.getFlag((long)flags, (long)0x100000L)) {
            int parentType;
            IType declaringType;
            IModelElement elem = type.getParent();
            IType iType = declaringType = elem instanceof IType ? (IType)elem : null;
            if (declaringType != null) {
                buf.append(" - ");
                this.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
                parentType = type.getParent().getElementType();
                if (parentType == 9 || parentType == 8) {
                    buf.append(this.getTypeDelimiter(elem));
                    this.getElementLabel(type.getParent(), 0L, buf);
                }
            }
            if ((parentType = type.getParent().getElementType()) == 9 || parentType == 8) {
                buf.append(" - ");
                this.getElementLabel(type.getParent(), (parentType == 9 ? 128L : 65536L) | flags & 0x1002000000000L, buf);
            }
        }
    }

    protected void getMethodLabel(IMethod method, long flags, StringBuffer buf) {
        try {
            IType declaringType;
            Object type;
            if (PHPElementLabels.getFlag((long)flags, (long)128L) && (type = method.getDeclaringType()) != null) {
                this.getTypeLabel((IType)type, 0x40000L | flags & 0x1002000000000L, buf);
                buf.append("::");
            }
            buf.append(method.getElementName());
            buf.append('(');
            this.getMethodParameters(method, flags, buf);
            buf.append(')');
            if (PHPElementLabels.getFlag((long)flags, (long)32L) && method.exists() && !method.isConstructor()) {
                type = method.getType();
                if (type == null) {
                    type = (method.getFlags() & 0x2000000) != 0 ? MIXED_RETURN_TYPE : VOID_RETURN_TYPE;
                }
                buf.append(" : ");
                if (PHPFlags.isNullable((int)method.getFlags())) {
                    buf.append(QUESTION_MARK);
                }
                buf.append((String)type);
            }
            if (PHPElementLabels.getFlag((long)flags, (long)256L) && (declaringType = method.getDeclaringType()) != null) {
                buf.append(" - ");
                this.getTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L, buf);
            }
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
    }

    protected void getMethodParameters(IMethod method, long flags, StringBuffer buf) throws ModelException {
        if (PHPElementLabels.getFlag((long)flags, (long)3L)) {
            if (method.exists()) {
                boolean bNames = PHPElementLabels.getFlag((long)flags, (long)2L);
                boolean bTypes = PHPElementLabels.getFlag((long)flags, (long)1L);
                boolean bInitializers = PHPElementLabels.getFlag((long)flags, (long)0x2000000000000L);
                IParameter[] params = method.getParameters();
                boolean isVariadic = PHPFlags.isVariadic((int)method.getFlags());
                int i = 0;
                int nParams = params.length;
                while (i < nParams) {
                    boolean isLast;
                    if (i > 0) {
                        buf.append(", ");
                    }
                    boolean bl = isLast = i + 1 == nParams;
                    if (bTypes) {
                        if (params[i].getType() != null) {
                            if (PHPFlags.isNullable((int)params[i].getFlags())) {
                                buf.append(QUESTION_MARK);
                            }
                            buf.append(params[i].getType());
                            if (bNames) {
                                buf.append(' ');
                            } else {
                                if (PHPFlags.isReference((int)params[i].getFlags())) {
                                    buf.append(REFERENCE_STRING);
                                }
                                if (isLast && isVariadic) {
                                    buf.append("...");
                                }
                            }
                        } else if (!bNames) {
                            if (PHPFlags.isReference((int)params[i].getFlags())) {
                                buf.append(REFERENCE_STRING);
                            }
                            if (isLast && isVariadic) {
                                buf.append("...");
                            }
                            buf.append(params[i].getName());
                        }
                    }
                    if (bNames) {
                        if (PHPFlags.isReference((int)params[i].getFlags())) {
                            buf.append(REFERENCE_STRING);
                        }
                        if (isLast && isVariadic) {
                            buf.append("...");
                        }
                        buf.append(params[i].getName());
                    }
                    if (bInitializers && params[i].getDefaultValue() != null) {
                        buf.append("=");
                        buf.append(params[i].getDefaultValue());
                    }
                    ++i;
                }
            }
        } else if (method.getParameters().length > 0) {
            buf.append("...");
        }
    }

    protected void getImportDeclarationLabel(IModelElement element, long flags, StringBuffer buf) {
        super.getImportDeclarationLabel(element, flags, buf);
        IImportDeclaration declaration = (IImportDeclaration)element;
        if (declaration.getAlias() != null) {
            buf.append(" as ");
            buf.append(declaration.getAlias());
        }
    }
}

