/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.EventObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.php.internal.core.preferences.TaskTagsProvider;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;

public class TaskTagsEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    @NonNull
    private TaskTag[] tags;
    private IProject project;
    private boolean isCaseSensitive;

    public TaskTagsEvent(@NonNull TaskTagsProvider provider, @Nullable IProject project, @NonNull TaskTag[] tags, boolean isCaseSensitive) {
        super(provider);
        this.project = project;
        this.tags = tags;
        this.isCaseSensitive = isCaseSensitive;
    }

    @Nullable
    public IProject getProject() {
        return this.project;
    }

    @NonNull
    public TaskTag[] getTaskTags() {
        return this.tags;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[TaskTagsEvent: project = ");
        if (this.project == null) {
            buffer.append("null");
        } else {
            buffer.append('\"');
            buffer.append(this.project);
            buffer.append('\"');
        }
        buffer.append(", TaskTags[");
        buffer.append(this.tags.length);
        buffer.append("] = {");
        int i = 0;
        while (i < this.tags.length) {
            if (this.tags[i] == null) {
                buffer.append("null");
            } else {
                buffer.append('\"');
                buffer.append(this.tags[i]);
                buffer.append('\"');
            }
            if (i + 1 < this.tags.length) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append('}');
        buffer.append(", Case-Sensitive = ");
        buffer.append(this.isCaseSensitive());
        buffer.append(']');
        return buffer.toString();
    }
}

