/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.PHPUnitSearchEngine;
import org.eclipse.php.phpunit.ui.ElementSelectionDialog;
import org.eclipse.php.phpunit.ui.wizards.PHPUnitWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TestSuiteWizardPage
extends PHPUnitWizardPage {
    private static final String PAGE_NAME = "TestCaseWizardPage";
    private static final String TEST_SUFFIX = "Suite";
    private ListDialogField<IType> fElementsToTestList;
    private Button addInterfacesBtn;
    private IType[] PHP_UNIT_SUITE_BASE_CLASS_CACHE;
    private IType[] PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE;

    public TestSuiteWizardPage() {
        super(PAGE_NAME);
        this.setTitle(PHPUnitMessages.TestSuiteWizardPage_5);
        this.setDescription(PHPUnitMessages.TestSuiteWizardPage_4);
        this.fSuperClassDialogField.setText("PHPUnit_Framework_TestSuite");
        this.superClassChanged();
    }

    public TestSuiteWizardPage(String pageName) {
        super(pageName);
    }

    @Override
    protected IType chooseSuperClass() {
        IContainer root = this.getTestContainer();
        if (root == null) {
            return null;
        }
        Shell shell = this.getShell();
        IProject project = root.getProject();
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        this.findSuiteBaseClasses(scriptProject);
        if (this.PHP_UNIT_SUITE_BASE_CLASS_CACHE != null && this.PHP_UNIT_SUITE_BASE_CLASS_CACHE.length > 0) {
            Object[] resultArray;
            ElementSelectionDialog dialog = new ElementSelectionDialog(shell, this.PHP_UNIT_SUITE_BASE_CLASS_CACHE);
            dialog.setTitle(PHPUnitMessages.PHPUnitWizardPage_10);
            dialog.setMessage(PHPUnitMessages.PHPUnitWizardPage_11);
            if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
                return (IType)resultArray[0];
            }
        }
        return null;
    }

    private void findSuiteBaseClasses(IScriptProject scriptProject) {
        if (this.PHP_UNIT_SUITE_BASE_CLASS_CACHE != null) {
            return;
        }
        PHPUnitSearchEngine searchEngine = new PHPUnitSearchEngine(scriptProject);
        ArrayList elementsList = new ArrayList();
        try {
            IWizardContainer container = this.getContainer();
            if (this.getControl() != null) {
                container.run(true, true, pm -> {
                    pm.beginTask(PHPUnitMessages.PHPUnitSearchEngine_Searching, -1);
                    List<IType> elements = searchEngine.findPHPUnitClassesByTestSuite((IModelElement)scriptProject, true, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (int)-1));
                    if (pm.isCanceled()) {
                        return;
                    }
                    elementsList.addAll(elements);
                    pm.done();
                });
                if (!elementsList.isEmpty()) {
                    this.PHP_UNIT_SUITE_BASE_CLASS_CACHE = elementsList.toArray(new IType[elementsList.size()]);
                }
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            PHPUnitPlugin.log(e);
        }
    }

    private void findAllNonAbstractSuitesAndCases(IScriptProject scriptProject) {
        if (this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE != null) {
            return;
        }
        PHPUnitSearchEngine searchEngine = new PHPUnitSearchEngine(scriptProject);
        ArrayList elementsList = new ArrayList();
        try {
            if (this.getContainer() != null && this.getContainer().getCurrentPage() != null) {
                this.getContainer().run(true, true, pm -> {
                    pm.beginTask(PHPUnitMessages.PHPUnitSearchEngine_Searching, -1);
                    List<IType> elements = searchEngine.findAllTestCasesAndSuites((IModelElement)scriptProject, false, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm));
                    if (pm.isCanceled()) {
                        return;
                    }
                    elementsList.addAll(elements);
                    pm.done();
                });
                if (!elementsList.isEmpty()) {
                    this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE = elementsList.toArray(new IType[elementsList.size()]);
                }
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            PHPUnitPlugin.log(e);
        }
    }

    @Override
    protected void containerChanged() {
        super.containerChanged();
        if (this.getTestContainer() != null) {
            String string = this.fClassNameProposal = this.getTestContainer() != null ? this.getTestContainer().getName() + this.testSuffix() : "";
            if (!this.fClassNameManual && this.fClassNameDialogField != null) {
                this.fClassNameDialogField.setText(this.fClassNameProposal);
            }
            this.classNameChanged();
            this.elementsToTestChanged();
        }
    }

    @Override
    protected void createContainerControls(Composite parent, int nColumns) {
        super.createContainerControls(parent, nColumns);
        IContainer container = this.getTestContainer();
        if (container != null) {
            this.setClassName(container.getName() + this.testSuffix());
        }
    }

    @Override
    protected void createElementToTestControls(Composite composite, int columns) {
        String[] stringArray = new String[3];
        stringArray[0] = "Add";
        stringArray[2] = "Remove";
        String[] addButtons = stringArray;
        IListAdapter<IType> listAdapter = new IListAdapter<IType>(){

            public void customButtonPressed(ListDialogField<IType> field, int index) {
            }

            public void doubleClicked(ListDialogField<IType> field) {
            }

            public void selectionChanged(ListDialogField<IType> field) {
            }
        };
        this.fElementsToTestList = new ListDialogField<IType>((IListAdapter)listAdapter, addButtons, (ILabelProvider)new PHPTypeListLabelProvider()){

            public void removeElement(IType element) throws IllegalArgumentException {
                super.removeElement((Object)element);
                TestSuiteWizardPage.this.elementsToTestChanged();
            }

            public void removeElements(List<IType> elements) {
                super.removeElements(elements);
                TestSuiteWizardPage.this.elementsToTestChanged();
            }

            public void removeAllElements() {
                super.removeAllElements();
                TestSuiteWizardPage.this.elementsToTestChanged();
            }
        };
        this.fElementsToTestList.setLabelText(PHPUnitMessages.TestSuiteWizardPage_2);
        this.fElementsToTestList.setRemoveButtonIndex(2);
        this.fElementsToTestList.removeAllElements();
        String INTERFACE = "interface";
        Control[] controls = this.fElementsToTestList.doFillIntoGrid(composite, 3);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        controls[1].setLayoutData((Object)gd);
        TableViewer tableViewer = this.fElementsToTestList.getTableViewer();
        tableViewer.setColumnProperties(new String[]{"interface"});
        gd = (GridData)this.fElementsToTestList.getListControl(null).getLayoutData();
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = this.getMaxFieldWidth();
        this.addInterfacesBtn = (Button)this.fElementsToTestList.getButtonBox(composite).getChildren()[0];
        this.addInterfacesBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IType[] result = TestSuiteWizardPage.this.choosePHPUnitElementsToTest();
                if (result != null && result.length > 0) {
                    TestSuiteWizardPage.this.fElementsToTestList.addElements(Arrays.asList(result));
                    TestSuiteWizardPage.this.fElementsToTestList.refresh();
                    TestSuiteWizardPage.this.elementsToTestChanged();
                }
            }
        });
    }

    protected IType[] choosePHPUnitElementsToTest() {
        IProject project = this.getTestContainer().getProject();
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        this.findAllNonAbstractSuitesAndCases(scriptProject);
        if (this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE != null && this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE.length > 0) {
            Object[] resultArray;
            ElementSelectionDialog dialog = new ElementSelectionDialog(this.getShell(), this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE);
            dialog.setTitle(PHPUnitMessages.PHPUnitWizardPage_10);
            dialog.setMessage(PHPUnitMessages.PHPUnitWizardPage_11);
            dialog.setMultipleSelection(true);
            if (dialog.open() == 0 && (resultArray = dialog.getResult()) != null && resultArray.length > 0) {
                IType[] typeResult = new IType[resultArray.length];
                int i = 0;
                while (i < resultArray.length) {
                    IType type;
                    typeResult[i] = type = (IType)resultArray[i];
                    ++i;
                }
                return typeResult;
            }
        }
        return null;
    }

    @Override
    protected String defaultSuperClass() {
        return "PHPUnit_Framework_TestSuite";
    }

    protected void elementsToTestChanged() {
        StatusInfo status = new StatusInfo();
        if (this.fElementsToTestList != null) {
            IProject project;
            List addedElementsToTest = this.fElementsToTestList.getElements();
            IType[] addedElementsToTestArray = addedElementsToTest.toArray(new IType[addedElementsToTest.size()]);
            if (this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE == null && this.getTestContainer() != null && this.getContainer().getCurrentPage() != null && (project = this.getTestContainer().getProject()) != null) {
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                this.findAllNonAbstractSuitesAndCases(scriptProject);
            }
            if (this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE != null) {
                List<IType> allTests = Arrays.asList(this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE);
                IType[] iTypeArray = addedElementsToTestArray;
                int n = addedElementsToTestArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType test = iTypeArray[n2];
                    if (!allTests.contains(test)) {
                        status.setError(MessageFormat.format(PHPUnitMessages.PHPUnitValidator_Not_Test, test.getElementName()));
                    }
                    ++n2;
                }
                this.fElementToTestStatus = status;
                this.updateStatus(this.getStatusList());
            }
        }
    }

    public IType[] getElementsToTest() {
        List elements = this.fElementsToTestList.getElements();
        return elements.toArray(new IType[elements.size()]);
    }

    @Override
    public Object init(IStructuredSelection selection) {
        super.init(selection);
        Object superClass = null;
        ArrayList<IContainer> containers = new ArrayList<IContainer>(1);
        IContainer container = null;
        for (Object next : selection) {
            IResource res;
            IModelElement element;
            container = this.getInitialContainer((IStructuredSelection)new StructuredSelection(next));
            if (container != null) {
                containers.add(container);
                continue;
            }
            if (superClass != null || (element = this.getInitialPHPElement((IStructuredSelection)new StructuredSelection(next))) == null || (res = element.getResource()) == null) continue;
            this.setContainer(res.getParent());
        }
        if (containers.size() > 1) {
            for (IContainer iContainer : containers) {
                if (iContainer.getType() == 4) {
                    container = iContainer;
                    break;
                }
                if (container != null && iContainer.getFullPath().segmentCount() >= container.getFullPath().segmentCount()) continue;
                container = iContainer;
            }
            for (IContainer iContainer : containers) {
                if (iContainer.getProject() != container.getProject()) continue;
                int j = 0;
                while (j < iContainer.getFullPath().segmentCount() - container.getFullPath().segmentCount()) {
                    iContainer = iContainer.getParent();
                    ++j;
                }
                if (iContainer == container) continue;
                container = container.getParent();
            }
            this.setContainer(container);
        } else if (!containers.isEmpty()) {
            this.setContainer((IContainer)containers.get(0));
        }
        return null;
    }

    @Override
    protected String testSuffix() {
        return TEST_SUFFIX;
    }

    @Override
    protected void invalidatCachedElements() {
        this.PHP_UNIT_SUITE_BASE_CLASS_CACHE = null;
        this.PHP_UNIT_CASE_AND_SUITE_NON_ABSTRAXT_CLASS_CACHE = null;
    }

    protected static class PHPTypeListLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        private Image fClassImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.png");
        private Image fAbsatractClassImage = PHPUiPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new PHPElementImageDescriptor(DLTKPluginImages.DESC_OBJS_CLASS, 4, PHPElementImageDescriptor.SMALL_SIZE));

        public String getText(Object element) {
            if (element != null) {
                String elementName = "";
                String fileName = "";
                if (element instanceof DLTKSearchTypeNameMatch) {
                    DLTKSearchTypeNameMatch typeMatch = (DLTKSearchTypeNameMatch)element;
                    IType type = typeMatch.getType();
                    elementName = type.getElementName();
                    fileName = type.getSourceModule().getElementName();
                } else if (element instanceof IType) {
                    IType sourceElement = (IType)element;
                    elementName = sourceElement.getElementName();
                    fileName = sourceElement.getSourceModule().getElementName();
                }
                StringBuilder result = new StringBuilder(elementName);
                result.append(" - ");
                result.append(fileName);
                return result.toString();
            }
            return "";
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element != null) {
                IType type = null;
                if (element instanceof DLTKSearchTypeNameMatch) {
                    DLTKSearchTypeNameMatch typeMatch = (DLTKSearchTypeNameMatch)element;
                    type = typeMatch.getType();
                }
                if (element instanceof IType) {
                    type = (IType)element;
                }
                if (type == null) {
                    return null;
                }
                try {
                    int flags = type.getFlags();
                    if (PHPFlags.isClass((int)flags)) {
                        result = PHPFlags.isAbstract((int)flags) ? this.fAbsatractClassImage : this.fClassImage;
                    }
                }
                catch (ModelException e) {
                    PHPUnitPlugin.log(e);
                }
            }
            return result;
        }

        public Image decorateImage(Image image, Object element) {
            return image;
        }

        public String decorateText(String text, Object element) {
            return text;
        }
    }
}

