/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.visitor.ApplyAll;

public class Locator
extends ApplyAll {
    private int offset;
    private ASTNode currentNode;

    public static Statement locateStatement(Program program, int offset) {
        if (program == null || offset < 0 || program.getLength() < offset) {
            throw new IllegalArgumentException();
        }
        for (Statement statement : program.statements()) {
            if (!Locator.inNode(statement, offset)) continue;
            return statement;
        }
        return null;
    }

    public static synchronized ASTNode locateNode(Program program, int offset) {
        if (program == null || !Locator.inNode(program, offset)) {
            throw new IllegalArgumentException();
        }
        Locator pathLocator = new Locator(offset);
        program.accept(pathLocator);
        return pathLocator.currentNode;
    }

    private Locator(int offset) {
        this.offset = offset;
    }

    private static final boolean inNode(ASTNode node, int offset) {
        return offset >= node.getStart() && node.getEnd() > offset;
    }

    @Override
    public boolean apply(ASTNode node) {
        assert (node != null);
        if (Locator.inNode(node, this.offset)) {
            this.currentNode = node;
            return true;
        }
        return false;
    }
}

