/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.folding.html.ProjectionAnnotationModelChanges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectionViewerInformation {
    private ProjectionAnnotationModel fProjectionAnnotationModel;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener;
    private boolean fIsDocumentChanging = false;
    private List<ProjectionAnnotationModelChanges> fQueuedAnnotationChanges;

    public ProjectionViewerInformation(ProjectionViewer viewer) {
        this.fDocument = viewer.getDocument();
        this.fProjectionAnnotationModel = viewer.getProjectionAnnotationModel();
    }

    IDocument getDocument() {
        return this.fDocument;
    }

    private List<ProjectionAnnotationModelChanges> getQueuedAnnotationChanges() {
        if (this.fQueuedAnnotationChanges == null) {
            this.fQueuedAnnotationChanges = Collections.synchronizedList(new ArrayList());
        }
        return this.fQueuedAnnotationChanges;
    }

    void setIsDocumentChanging(boolean changing) {
        this.fIsDocumentChanging = changing;
    }

    private boolean isDocumentChanging() {
        return this.fIsDocumentChanging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyAnnotationModelChanges() {
        List<ProjectionAnnotationModelChanges> queuedChanges;
        ArrayList<ProjectionAnnotationModelChanges> changesToApply = new ArrayList<ProjectionAnnotationModelChanges>();
        List<ProjectionAnnotationModelChanges> list = queuedChanges = this.getQueuedAnnotationChanges();
        synchronized (list) {
            changesToApply.addAll(queuedChanges);
            queuedChanges.clear();
        }
        queuedChanges = null;
        while (!changesToApply.isEmpty()) {
            ProjectionAnnotationModelChanges changes = (ProjectionAnnotationModelChanges)changesToApply.remove(0);
            try {
                this.fProjectionAnnotationModel.modifyAnnotations(changes.getDeletions(), changes.getAdditions(), changes.getModifications());
            }
            catch (Exception e) {
                Logger.log((int)202, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    boolean hasChangesQueued() {
        return !this.getQueuedAnnotationChanges().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueAnnotationModelChanges(ProjectionAnnotationModelChanges newChange) {
        List<ProjectionAnnotationModelChanges> changes;
        List<ProjectionAnnotationModelChanges> list = changes = this.getQueuedAnnotationChanges();
        synchronized (list) {
            int index = changes.indexOf(newChange);
            if (index > -1) {
                changes.get(index).updateChange(newChange);
            } else {
                changes.add(newChange);
            }
        }
        if (!this.isDocumentChanging()) {
            this.applyAnnotationModelChanges();
        }
    }

    public void initialize() {
        if (this.fDocumentListener == null) {
            this.fDocumentListener = new DocumentListener(this);
        }
        this.getDocument().addDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fDocumentListener != null) {
            this.getDocument().removeDocumentListener(this.fDocumentListener);
        }
        if (this.fQueuedAnnotationChanges != null) {
            this.fQueuedAnnotationChanges.clear();
            this.fQueuedAnnotationChanges = null;
        }
    }

    private class ApplyAnnotationModelChangesJob
    extends Job {
        ProjectionViewerInformation fInfo;

        public ApplyAnnotationModelChangesJob(String name, ProjectionViewerInformation fInfo) {
            super(name);
            this.fInfo = fInfo;
        }

        public boolean belongsTo(Object family) {
            return this.getName().equals(family);
        }

        public IStatus run(IProgressMonitor monitor) {
            this.fInfo.applyAnnotationModelChanges();
            this.fInfo.setIsDocumentChanging(false);
            return Status.OK_STATUS;
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        private ProjectionViewerInformation fInfo;

        public DocumentListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (this.fInfo.getDocument() == document) {
                this.fInfo.setIsDocumentChanging(true);
            }
        }

        public void documentChanged(DocumentEvent event) {
            IDocument document = event.getDocument();
            if (document instanceof IDocumentExtension && this.fInfo.getDocument() == document && this.fInfo.hasChangesQueued()) {
                ((IDocumentExtension)document).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)new PostDocumentChangedListener(this.fInfo));
            }
        }
    }

    private class PostDocumentChangedListener
    implements IDocumentExtension.IReplace {
        private ProjectionViewerInformation fInfo;

        public PostDocumentChangedListener(ProjectionViewerInformation info) {
            this.fInfo = info;
        }

        public void perform(IDocument document, IDocumentListener owner) {
            IJobManager jobManager = Job.getJobManager();
            if (jobManager.find((Object)"Applying annotation model changes").length == 0) {
                ApplyAnnotationModelChangesJob job = new ApplyAnnotationModelChangesJob("Applying annotation model changes", this.fInfo);
                job.setPriority(50);
                job.setSystem(true);
                job.schedule();
            }
        }
    }
}

