/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;

public class ParameterVariableHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new ParameterVariableApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setUnderlineByDefault(true);
    }

    public String getDisplayName() {
        return "Parameter variables";
    }

    protected class ParameterVariableApply
    extends AbstractSemanticApply {
        private Collection<String> params = new LinkedList<String>();

        protected ParameterVariableApply() {
        }

        public boolean visit(FunctionDeclaration functionDecl) {
            for (FormalParameter param : functionDecl.formalParameters()) {
                this.params.add(param.getParameterNameIdentifier().getName());
            }
            return true;
        }

        public void endVisit(Variable variable) {
            Expression varName;
            if ((variable.getParent().getType() != 24 || variable.getParent().getType() == 24 && ((FieldAccess)variable.getParent()).getDispatcher() == variable) && this.params.contains(((Identifier)(varName = variable.getName())).getName()) && varName instanceof Identifier && variable.isDollared() && variable.getParent().getType() != 52) {
                ParameterVariableHighlighting.this.highlight((ASTNode)variable);
            }
        }

        public void endVisit(FunctionDeclaration functionDecl) {
            this.params.clear();
        }
    }
}

