/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.internal.core.refactoring.resource.MoveResourcesProcessor;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.ui.actions.AbstractMoveDelegator;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.IPHPActionDelegator;
import org.eclipse.php.internal.ui.actions.PHPActionDelegatorRegistry;
import org.eclipse.php.internal.ui.actions.PHPMoveProjectAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ReorgMoveAction
extends AbstractMoveDelegator {
    private static final String MOVE_ELEMENT_ACTION_ID = "org.eclipse.php.ui.actions.Move";
    private IStructuredSelection selectedResources;
    private Shell fShell;
    private AbstractMoveDelegator moveActionDelegate;
    private IContainer target;

    public void run(IStructuredSelection selection) {
        SelectionListenerAction action;
        if (ActionUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        if (this.selectedResources != null && !this.selectedResources.isEmpty() && (action = this.createWorkbenchAction(this.selectedResources)) != null) {
            action.run();
        }
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection selection) {
        List list = selection.toList();
        PHPMoveProjectAction action = null;
        if (this.fShell == null) {
            this.fShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (list.size() == 0 || list.get(0) instanceof IProject || list.get(0) instanceof IAdaptable && ((IAdaptable)list.get(0)).getAdapter(IResource.class) instanceof IProject) {
            action = new PHPMoveProjectAction(this.fShell);
            action.selectionChanged(selection);
        } else if (this.selectedResources != null) {
            IResource resource;
            Object object;
            action = new MoveResourceAction(this.fShell);
            if (list.size() == 1 && (object = list.get(0)) instanceof ElementImplForPhp && ((ElementImplForPhp)object).getModelElement() != null && (resource = ((ElementImplForPhp)object).getModelElement().getResource()) != null) {
                selection = new StructuredSelection((Object)resource);
            }
            action.selectionChanged(selection);
        }
        return action;
    }

    protected boolean directMove(IStructuredSelection selection) {
        IResource[] resources = new IResource[selection.size()];
        Iterator iterator = selection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            resources[i++] = (IResource)iterator.next();
        }
        MoveResourcesProcessor processor = new MoveResourcesProcessor(resources);
        processor.setDestination(this.target);
        ProcessorBasedRefactoring refactoring = new ProcessorBasedRefactoring((RefactoringProcessor)processor);
        CheckConditionsOperation checkOp = new CheckConditionsOperation((Refactoring)refactoring, 6);
        CreateChangeOperation operation = new CreateChangeOperation(checkOp, 2);
        PerformChangeOperation perform = new PerformChangeOperation(operation);
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)perform, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            PHPCorePlugin.log((IStatus)e.getStatus());
            return false;
        }
        RefactoringStatus status = perform.getValidationStatus();
        if (status == null) {
            RefactoringStatus refactoringStatus = checkOp.getStatus();
            if (refactoringStatus != null && !refactoringStatus.isOK()) {
                MessageDialog.openError((Shell)this.fShell, (String)"Error moving resource", (String)"A resource with the same name exists in the target folder.");
            }
            return false;
        }
        return true;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null) {
            if (this.moveActionDelegate == null) {
                this.init(targetEditor.getSite().getWorkbenchWindow());
            }
            if (this.moveActionDelegate != null && !(this.moveActionDelegate instanceof ReorgMoveAction)) {
                this.moveActionDelegate.setActiveEditor(action, targetEditor);
            } else {
                IEditorInput editorInput = targetEditor.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    IFileEditorInput input = (IFileEditorInput)editorInput;
                    IFile file = input.getFile();
                    this.selectedResources = new StructuredSelection((Object)file);
                }
            }
        }
    }

    public void run(IAction action) {
        if (this.moveActionDelegate != null) {
            if (this.target != null) {
                this.moveActionDelegate.setTarget(this.target);
            }
            this.moveActionDelegate.run(action);
        } else {
            this.run(this.selectedResources);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.moveActionDelegate != null) {
            this.moveActionDelegate.selectionChanged(action, selection);
        } else if (selection instanceof IStructuredSelection) {
            this.selectedResources = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void setTarget(IContainer target) {
        this.target = target;
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
        IPHPActionDelegator action = PHPActionDelegatorRegistry.getActionDelegator(MOVE_ELEMENT_ACTION_ID);
        if (action instanceof AbstractMoveDelegator) {
            this.moveActionDelegate = (AbstractMoveDelegator)action;
        }
    }
}

