/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.refactoring.actions.RenameResourceAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.PHPActionDelegatorRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class RenameAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private IActionDelegate fRenamePHPElement;
    private RenameResourceAction resourceAction;
    private ISelection selection;
    private static final String RENAME_ELEMENT_ACTION_ID = "org.eclipse.php.ui.actions.RenameElement";

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        if (window != null) {
            this.init();
            if (this.fRenamePHPElement == null) {
                IWorkbenchPage page = window.getActivePage();
                if (page != null && page.getActivePart() != null) {
                    this.resourceAction = new RenameResourceAction((IWorkbenchSite)page.getActivePart().getSite());
                }
            } else if (this.fRenamePHPElement instanceof IWorkbenchWindowActionDelegate) {
                ((IWorkbenchWindowActionDelegate)this.fRenamePHPElement).init(window);
            }
        }
    }

    private void init() {
        this.fRenamePHPElement = PHPActionDelegatorRegistry.getActionDelegator(RENAME_ELEMENT_ACTION_ID);
    }

    public void run(IAction action) {
        if (this.resourceAction != null) {
            if (!this.selection.isEmpty()) {
                Object object = ((IStructuredSelection)this.selection).getFirstElement();
                IResource resource = null;
                if (object instanceof IModelElement) {
                    resource = ((IModelElement)object).getResource();
                }
                if (object instanceof IResource) {
                    resource = (IResource)object;
                }
                if (object instanceof ElementImplForPhp) {
                    resource = ((ElementImplForPhp)object).getModelElement().getResource();
                }
                if (resource != null) {
                    StructuredSelection resourceSel = new StructuredSelection((Object)resource);
                    this.resourceAction.run((IStructuredSelection)resourceSel);
                } else {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)PHPUIMessages.RenamePHPElementAction_name, (String)PHPUIMessages.RenamePHPElementAction_not_available);
                }
            }
        } else {
            this.fRenamePHPElement.run(action);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        if (this.fRenamePHPElement != null) {
            this.fRenamePHPElement.selectionChanged(action, selection);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (this.fRenamePHPElement == null) {
            this.init();
        }
        if (targetEditor != null && this.resourceAction == null && this.fRenamePHPElement == null) {
            this.resourceAction = new RenameResourceAction((IWorkbenchSite)targetEditor.getSite());
        }
        if (this.fRenamePHPElement instanceof IEditorActionDelegate) {
            ((IEditorActionDelegate)this.fRenamePHPElement).setActiveEditor(action, targetEditor);
        }
    }
}

