/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class IfStatement
extends Statement {
    private final Expression condition;
    private final Statement trueStatement;
    private final Statement falseStatement;

    public IfStatement(int start, int end, Expression condition, Statement trueStatement, Statement falseStatement) {
        super(start, end);
        assert (condition != null && trueStatement != null);
        this.condition = condition;
        this.trueStatement = trueStatement;
        this.falseStatement = falseStatement;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.condition.traverse(visitor);
            this.trueStatement.traverse(visitor);
            if (this.falseStatement != null) {
                this.falseStatement.traverse(visitor);
            }
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 34;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getFalseStatement() {
        return this.falseStatement;
    }

    public Statement getTrueStatement() {
        return this.trueStatement;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

