/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ConditionalExpression
extends Expression {
    private final Expression condition;
    private final Expression ifTrue;
    private final Expression ifFalse;

    public ConditionalExpression(int start, int end, Expression condition, Expression ifTrue, Expression ifFalse) {
        super(start, end);
        assert (condition != null && ifFalse != null);
        this.condition = condition;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            this.condition.traverse(visitor);
            if (this.ifTrue != null) {
                this.ifTrue.traverse(visitor);
            }
            this.ifFalse.traverse(visitor);
        }
        visitor.endvisit((Expression)this);
    }

    public int getKind() {
        return 17;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getIfFalse() {
        return this.ifFalse;
    }

    public Expression getIfTrue() {
        return this.ifTrue;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

